/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.ReferenceableClassification;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.ReferenceableHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReferenceableHeaderConverter {
    public static final String QUALIFIED_NAME_PROPERTY_NAME = "qualifiedName";
    public static final String ADDITIONAL_PROPERTIES_PROPERTY_NAME = "additionalProperties";
    private static final String unknownProvenance = "<Unknown>";
    private ReferenceableHeader bean = null;
    private EntityDetail entity;
    private OMRSRepositoryHelper repositoryHelper;
    private String componentName;

    ReferenceableHeaderConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String componentName) {
        this.entity = entity;
        this.repositoryHelper = repositoryHelper;
        this.componentName = componentName;
    }

    void setBean(ReferenceableHeader bean) {
        this.bean = bean;
        this.updateBean(this.entity, this.repositoryHelper, this.componentName);
    }

    private void updateBean(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String componentName) {
        String methodName = "updateBean";
        if (entity != null) {
            this.bean.setGUID(entity.getGUID());
            InstanceType instanceType = entity.getType();
            if (instanceType != null) {
                this.bean.setTypeName(instanceType.getTypeDefName());
                this.bean.setTypeDescription(instanceType.getTypeDefDescription());
            }
            this.bean.setOriginId(entity.getMetadataCollectionId());
            this.bean.setOriginName(entity.getMetadataCollectionName());
            if (entity.getInstanceProvenanceType() != null) {
                this.bean.setOriginType(entity.getInstanceProvenanceType().getName());
            } else {
                this.bean.setOriginType(unknownProvenance);
            }
            this.bean.setOriginLicense(entity.getInstanceLicense());
            this.bean.setClassifications(this.getEntityClassifications(entity, repositoryHelper));
            InstanceProperties instanceProperties = entity.getProperties();
            this.bean.setQualifiedName(repositoryHelper.getStringProperty(componentName, QUALIFIED_NAME_PROPERTY_NAME, instanceProperties, "updateBean"));
            this.bean.setAdditionalProperties(repositoryHelper.getMapFromProperty(componentName, ADDITIONAL_PROPERTIES_PROPERTY_NAME, instanceProperties, "updateBean"));
        }
    }

    private List<ReferenceableClassification> getEntityClassifications(EntityDetail entity, OMRSRepositoryHelper repositoryHelper) {
        List entityClassifications;
        ArrayList classifications = null;
        if (entity != null && (entityClassifications = entity.getClassifications()) != null) {
            classifications = new ArrayList();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ReferenceableClassification beanClassification = new ReferenceableClassification();
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
            }
        }
        return classifications;
    }
}

