/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.handlers;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerAssetInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AmbiguousConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NoConnectedAssetException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.ConnectionHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.ErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;

public class AssetHandler
implements AssetConsumerAssetInterface {
    private static final String connectionToAssetRelationshipGUID = "e777d660-8dbe-453e-8b83-903771f054c0";
    private String serviceName;
    private OMRSRepositoryConnector repositoryConnector;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private ErrorHandler errorHandler = null;

    public AssetHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        this.repositoryConnector = repositoryConnector;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
        }
    }

    public String getAssetForConnection(String userId, String connectionGUID) throws InvalidParameterException, NoConnectedAssetException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnection";
        String guidParameter = "connectionGUID";
        this.errorHandler.validateUserId(userId, "getAssetForConnection");
        this.errorHandler.validateGUID(connectionGUID, "connectionGUID", "getAssetForConnection");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getAssetForConnection");
        try {
            List relationships = metadataCollection.getRelationshipsForEntity(userId, connectionGUID, null, 0, null, null, null, null, 0);
            Relationship assetRelationship = null;
            for (Relationship retrievedRelationship : relationships) {
                InstanceType type;
                if (retrievedRelationship == null || (type = retrievedRelationship.getType()) == null || !connectionToAssetRelationshipGUID.equals(type.getTypeDefGUID())) continue;
                if (assetRelationship == null) {
                    assetRelationship = retrievedRelationship;
                    continue;
                }
                AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.MULTIPLE_ASSETS_FOUND;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{connectionGUID});
                throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAssetForConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (assetRelationship == null) {
                AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.ASSET_NOT_FOUND;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{connectionGUID});
                throw new NoConnectedAssetException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAssetForConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), connectionGUID);
            }
            EntityProxy end2 = assetRelationship.getEntityTwoProxy();
            if (end2 != null) {
                return end2.getGUID();
            }
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_END2_RETURNED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{connectionToAssetRelationshipGUID, assetRelationship.getGUID(), assetRelationship.toString()});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAssetForConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (NoConnectedAssetException | PropertyServerException error) {
            throw error;
        }
        catch (EntityNotKnownException error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CONNECTION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{connectionGUID, this.serverName, error.getErrorMessage()});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAssetForConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), connectionGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getAssetForConnection", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getAssetForConnection", this.serverName, this.serviceName);
        }
        return null;
    }

    public String getAssetForConnectionName(String userId, String connectionName) throws InvalidParameterException, AmbiguousConnectionNameException, NoConnectedAssetException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnectionName";
        ConnectionHandler connectionHandler = new ConnectionHandler(this.serviceName, this.repositoryConnector);
        Connection connection = connectionHandler.getConnectionByName(userId, connectionName);
        if (connection != null) {
            return this.getAssetForConnection(userId, connection.getGUID());
        }
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CONNECTION_NOT_FOUND;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{connectionName, this.serverName, null});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAssetForConnectionName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), connectionName);
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }
}

