/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.handlers;

import org.odpi.openmetadata.accessservices.assetconsumer.auditlog.AssetConsumerAuditCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogHandler {
    private static final Logger log = LoggerFactory.getLogger(AuditLogHandler.class);
    private String serviceName;
    private OMRSAuditLog auditLog;

    public AuditLogHandler(String serviceName, OMRSAuditLog auditLog) {
        this.serviceName = serviceName;
        this.auditLog = auditLog;
    }

    public void addLogMessageToAsset(String userId, String assetGUID, String connectorInstanceId, String connectionName, String connectorType, String contextId, String message) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLogMessageToAsset";
        String additionalInformation = "User: " + userId + "ContextId: " + contextId + "Connector Instance Id: " + connectorInstanceId + "Connection Name: " + connectionName + "Connector Type: " + connectorType;
        AssetConsumerAuditCode auditCode = AssetConsumerAuditCode.ASSET_AUDIT_LOG;
        this.auditLog.logRecord("addLogMessageToAsset", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(assetGUID, message), additionalInformation, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

