/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.handlers;

import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class ErrorHandler {
    private OMRSRepositoryConnector repositoryConnector;

    ErrorHandler(OMRSRepositoryConnector repositoryConnector) {
        this.repositoryConnector = repositoryConnector;
    }

    void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (userId == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "userId");
        }
    }

    void validateGUID(String guid, String parameterName, String methodName) throws InvalidParameterException {
        if (guid == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateEnum(Object enumValue, String parameterName, String methodName) throws InvalidParameterException {
        if (enumValue == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_ENUM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateName(String name, String parameterName, String methodName) throws InvalidParameterException {
        if (name == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateText(String text, String parameterName, String methodName) throws InvalidParameterException {
        if (text == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_TEXT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "text");
        }
    }

    void validatePaging(int startFrom, int pageSize, String methodName) throws InvalidParameterException {
        String startFromParameterName = "startFrom";
        String pageSizeParameterName = "pageSize";
        if (startFrom < 0) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NEGATIVE_START_FROM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"startFrom", methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "startFrom");
        }
        if (pageSize < 1) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.EMPTY_PAGE_SIZE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"pageSize", methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "pageSize");
        }
    }

    OMRSMetadataCollection validateRepositoryConnector(String methodName) throws PropertyServerException {
        if (this.repositoryConnector == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!this.repositoryConnector.isActive()) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.OMRS_NOT_AVAILABLE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            return this.repositoryConnector.getMetadataCollection();
        }
        catch (Throwable error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NO_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void handleUnauthorizedUser(String userId, String methodName, String serverName, String serviceName) throws UserNotAuthorizedException {
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.USER_NOT_AUTHORIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, methodName, serviceName, serverName});
        throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
    }

    void handleRepositoryError(Throwable error, String methodName, String serverName, String serviceName) throws PropertyServerException {
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.PROPERTY_SERVER_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getMessage(), methodName, serviceName, serverName});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    void handleUnknownAsset(Throwable error, String assetGUID, String methodName, String serverName, String serviceName) throws InvalidParameterException {
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.UNKNOWN_ASSET;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetGUID, methodName, serviceName, serverName, error.getMessage()});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "assetGUID");
    }
}

