/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerGlossaryInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.converters.GlossaryTermConverter;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.ErrorHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.GlossaryTerm;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;

public class MeaningHandler
implements AssetConsumerGlossaryInterface {
    private static final String glossaryTermGUID = "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a";
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private ErrorHandler errorHandler = null;

    public MeaningHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
        }
    }

    public List<GlossaryTerm> getMeaningByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMeaningsByName";
        String nameParameter = "name";
        ArrayList<GlossaryTerm> results = new ArrayList<GlossaryTerm>();
        this.errorHandler.validateUserId(userId, "getMeaningsByName");
        this.errorHandler.validateName(name, "name", "getMeaningsByName");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getMeaningsByName");
        try {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", name, "getMeaningsByName");
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", name, "getMeaningsByName");
            List glossaryTermEntities = metadataCollection.findEntitiesByProperty(userId, glossaryTermGUID, properties, MatchCriteria.ANY, startFrom, null, null, null, null, null, pageSize);
            if (glossaryTermEntities == null) {
                return null;
            }
            if (glossaryTermEntities.isEmpty()) {
                return null;
            }
            for (EntityDetail termEntity : glossaryTermEntities) {
                if (termEntity == null) continue;
                GlossaryTermConverter converter = new GlossaryTermConverter(termEntity, this.repositoryHelper, this.serviceName);
                results.add(converter.getBean());
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getMeaningsByName", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getMeaningsByName", this.serverName, this.serviceName);
        }
        return null;
    }

    public GlossaryTerm getMeaning(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMeaningByGUID";
        String guidParameter = "guid";
        this.errorHandler.validateUserId(userId, "getMeaningByGUID");
        this.errorHandler.validateGUID(guid, "guid", "getMeaningByGUID");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getMeaningByGUID");
        EntityDetail termEntity = null;
        try {
            termEntity = metadataCollection.getEntityDetail(userId, guid);
        }
        catch (EntityNotKnownException error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.TERM_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, this.serverName, error.getErrorMessage()});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMeaningByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "guid");
        }
        catch (EntityProxyOnlyException error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.PROXY_TERM_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, this.serverName, error.getErrorMessage()});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMeaningByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "guid");
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getMeaningByGUID", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getMeaningByGUID", this.serverName, this.serviceName);
        }
        if (termEntity != null) {
            GlossaryTermConverter converter = new GlossaryTermConverter(termEntity, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }
}

