/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.handlers;

import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.ErrorHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class RepositoryHandler {
    private String serviceName;
    private String serverName = null;
    private ErrorHandler errorHandler = null;

    RepositoryHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
        }
    }

    void validateEntityGUID(String userId, String guid, String assetTypeName, OMRSMetadataCollection metadataCollection, String methodName) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        try {
            metadataCollection.getEntitySummary(userId, guid);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownAsset(error, guid, methodName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
    }
}

