/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.handlers;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerTaggingInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.ErrorHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.RepositoryHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.Tag;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class TaggingHandler
implements AssetConsumerTaggingInterface {
    private static final String informalTagTypeName = "InformalTag";
    private static final String informalTagTypeGUID = "ba846a7b-2955-40bf-952b-2793ceca090a";
    private static final String privateTagTypeName = "PrivateTag";
    private static final String privateTagTypeGUID = "9b3f5443-2475-4522-bfda-8f1f17e9a6c3";
    private static final String tagNamePropertyName = "TagName";
    private static final String tagDescriptionPropertyName = "TagDescription";
    private static final String attachedTagTypeGUID = "4b1641c4-3d1a-4213-86b2-d6968b6c65ab";
    private static final String assetTypeName = "Asset";
    private String serviceName;
    private String serverName = null;
    private OMRSRepositoryHelper repositoryHelper = null;
    private ErrorHandler errorHandler = null;
    private RepositoryHandler basicHandler = null;

    public TaggingHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
            this.basicHandler = new RepositoryHandler(serviceName, repositoryConnector);
        }
    }

    private String addTagToAsset(String tagTypeGUID, String userId, String assetGUID, String tagName, String tagDescription, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "assetGUID";
        String nameParameter = "tagName";
        this.errorHandler.validateUserId(userId, methodName);
        this.errorHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.errorHandler.validateName(tagName, "tagName", methodName);
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector(methodName);
        this.basicHandler.validateEntityGUID(userId, assetGUID, assetTypeName, metadataCollection, methodName);
        try {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, tagNamePropertyName, tagName, methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, tagDescriptionPropertyName, tagDescription, methodName);
            EntityDetail feedbackEntity = metadataCollection.addEntity(userId, tagTypeGUID, properties, null, InstanceStatus.ACTIVE);
            String feedbackGUID = null;
            if (feedbackEntity != null) {
                feedbackGUID = feedbackEntity.getGUID();
            }
            return feedbackGUID;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
        return null;
    }

    public String createPublicTag(String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPublicTag";
        return null;
    }

    public String createPrivateTag(String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPrivateTag";
        return null;
    }

    public void updateTagDescription(String userId, String tagGUID, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateTagDescription";
    }

    public void deleteTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteTag";
    }

    public Tag getTag(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTag";
        return null;
    }

    public List<Tag> getTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTagsByName";
        return null;
    }

    public void addTagToAsset(String userId, String assetGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addTagToAsset";
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("addTagToAsset");
        this.basicHandler.validateEntityGUID(userId, assetGUID, assetTypeName, metadataCollection, "addTagToAsset");
        this.basicHandler.validateEntityGUID(userId, tagGUID, informalTagTypeName, metadataCollection, "addTagToAsset");
        try {
            metadataCollection.addRelationship(userId, attachedTagTypeGUID, null, assetGUID, tagGUID, InstanceStatus.ACTIVE);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "addTagToAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "addTagToAsset", this.serverName, this.serviceName);
        }
    }

    public void removeTagFromAsset(String userId, String assetGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTagFromAsset";
        String guidParameter = "tagGUID";
        this.errorHandler.validateUserId(userId, "removeTagFromAsset");
        this.errorHandler.validateGUID(tagGUID, "tagGUID", "removeTagFromAsset");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("removeTagFromAsset");
        try {
            metadataCollection.deleteEntity(userId, informalTagTypeGUID, informalTagTypeName, tagGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "removeTagFromAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "removeTagFromAsset", this.serverName, this.serviceName);
        }
    }
}

