/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerRegistration;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerServicesInstance;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerServicesInstanceMap;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class AssetConsumerInstanceHandler {
    private static AssetConsumerServicesInstanceMap instanceMap = new AssetConsumerServicesInstanceMap();
    private static AccessServiceDescription myDescription = AccessServiceDescription.ASSET_CONSUMER_OMAS;

    AssetConsumerInstanceHandler() {
        AssetConsumerRegistration.registerAccessService();
    }

    OMRSMetadataCollection getMetadataCollection(String serverName) throws PropertyServerException {
        AssetConsumerServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getMetadataCollection();
        }
        String methodName = "getMetadataCollection";
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getMetadataCollection"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public String getAccessServiceName() {
        return myDescription.getAccessServiceName();
    }

    OMRSRepositoryConnector getRepositoryConnector(String serverName) throws PropertyServerException {
        AssetConsumerServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRepositoryConnector();
        }
        String methodName = "getRepositoryConnector";
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    OMRSAuditLog getAuditLog(String serverName) throws PropertyServerException {
        AssetConsumerServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getAuditLog();
        }
        String methodName = "getAuditLog";
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getAuditLog"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAuditLog", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

