/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AmbiguousConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AssetConsumerCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NoConnectedAssetException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.AssetHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.AuditLogHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.ConnectionHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.FeedbackHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.MeaningHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.TaggingHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetConsumerOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.CommentRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MeaningListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MeaningResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ReviewRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetConsumerRESTServices {
    private static AssetConsumerInstanceHandler instanceHandler = new AssetConsumerInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(AssetConsumerRESTServices.class);

    public GUIDResponse getAssetForConnection(String serverName, String userId, String connectionGUID) {
        String methodName = "getAssetForConnection";
        log.debug("Calling method: getAssetForConnection");
        GUIDResponse response = new GUIDResponse();
        try {
            AssetHandler assetHandler = new AssetHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(assetHandler.getAssetForConnection(userId, connectionGUID));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (NoConnectedAssetException error) {
            this.captureNoConnectedAssetException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getAssetForConnection with response: " + response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByName(String serverName, String userId, String name) {
        String methodName = "getConnectionByName";
        log.debug("Calling method: getConnectionByName");
        ConnectionResponse response = new ConnectionResponse();
        try {
            ConnectionHandler connectionHandler = new ConnectionHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setConnection(connectionHandler.getConnectionByName(userId, name));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (AmbiguousConnectionNameException error) {
            this.captureAmbiguousConnectionNameException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getConnectionByName with response: " + response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByGUID(String serverName, String userId, String guid) {
        String methodName = "getConnectionByGUID";
        log.debug("Calling method: getConnectionByGUID");
        ConnectionResponse response = new ConnectionResponse();
        try {
            ConnectionHandler connectionHandler = new ConnectionHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setConnection(connectionHandler.getConnectionByGUID(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getConnectionByGUID with response: " + response.toString());
        return response;
    }

    public GUIDResponse addReviewToAsset(String serverName, String userId, String guid, ReviewRequestBody requestBody) {
        String methodName = "addReviewToAsset";
        log.debug("Calling method: addReviewToAsset");
        GUIDResponse response = new GUIDResponse();
        try {
            StarRating starRating = null;
            String review = null;
            if (requestBody != null) {
                starRating = requestBody.getStarRating();
                review = requestBody.getReview();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(feedbackHandler.addReviewToAsset(userId, guid, starRating, review));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addReviewToAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse updateReviewOnAsset(String serverName, String userId, String guid, ReviewRequestBody requestBody) {
        String methodName = "updateReviewOnAsset";
        log.debug("Calling method: updateReviewOnAsset");
        VoidResponse response = new VoidResponse();
        try {
            StarRating starRating = null;
            String review = null;
            if (requestBody != null) {
                starRating = requestBody.getStarRating();
                review = requestBody.getReview();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            feedbackHandler.updateReviewOnAsset(userId, guid, starRating, review);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: updateReviewOnAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse removeReviewFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRating";
        log.debug("Calling method: removeRating");
        VoidResponse response = new VoidResponse();
        try {
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            feedbackHandler.removeReviewFromAsset(userId, guid);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeRating with response: " + response.toString());
        return response;
    }

    public GUIDResponse addLikeToAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "addLikeToAsset";
        log.debug("Calling method: addLikeToAsset");
        GUIDResponse response = new GUIDResponse();
        try {
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(feedbackHandler.addLikeToAsset(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addLikeToAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse removeLikeFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLikeFromAsset";
        log.debug("Calling method: removeLikeFromAsset");
        VoidResponse response = new VoidResponse();
        try {
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            feedbackHandler.removeLikeFromAsset(userId, guid);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeLikeFromAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addCommentToAsset(String serverName, String userId, String guid, CommentRequestBody requestBody) {
        String methodName = "addCommentToAsset";
        log.debug("Calling method: addCommentToAsset");
        GUIDResponse response = new GUIDResponse();
        try {
            CommentType commentType = null;
            String commentText = null;
            if (requestBody != null) {
                commentType = requestBody.getCommentType();
                commentText = requestBody.getCommentText();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(feedbackHandler.addCommentToAsset(userId, guid, commentType, commentText));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addCommentToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String userId, String commentGUID, CommentRequestBody requestBody) {
        String methodName = "addCommentReply";
        log.debug("Calling method: addCommentReply");
        GUIDResponse response = new GUIDResponse();
        try {
            CommentType commentType = null;
            String commentText = null;
            if (requestBody != null) {
                commentType = requestBody.getCommentType();
                commentText = requestBody.getCommentText();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(feedbackHandler.addCommentReply(userId, commentGUID, commentType, commentText));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addCommentReply with response: " + response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String userId, String guid, CommentRequestBody requestBody) {
        String methodName = "updateComment";
        log.debug("Calling method: updateComment");
        VoidResponse response = new VoidResponse();
        try {
            CommentType commentType = null;
            String commentText = null;
            if (requestBody != null) {
                commentType = requestBody.getCommentType();
                commentText = requestBody.getCommentText();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            feedbackHandler.updateComment(userId, guid, commentType, commentText);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: updateComment with response: " + response.toString());
        return response;
    }

    public VoidResponse removeCommentFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeCommentFromAsset";
        log.debug("Calling method: removeCommentFromAsset");
        VoidResponse response = new VoidResponse();
        try {
            FeedbackHandler feedbackHandler = new FeedbackHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            feedbackHandler.removeCommentFromAsset(userId, guid);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeCommentFromAsset with response: " + response.toString());
        return response;
    }

    public MeaningResponse getMeaning(String serverName, String userId, String guid) {
        String methodName = "getMeaning";
        log.debug("Calling method: getMeaning");
        MeaningResponse response = new MeaningResponse();
        try {
            MeaningHandler meaningHandler = new MeaningHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGlossaryTerm(meaningHandler.getMeaning(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getMeaning with response: " + response.toString());
        return response;
    }

    public MeaningListResponse getMeaningByName(String serverName, String userId, String term, int startFrom, int pageSize) {
        String methodName = "getMeaningByName";
        log.debug("Calling method: getMeaningByName");
        MeaningListResponse response = new MeaningListResponse();
        try {
            MeaningHandler meaningHandler = new MeaningHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setMeanings(meaningHandler.getMeaningByName(userId, term, startFrom, pageSize));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getMeaningByName with response: " + response.toString());
        return response;
    }

    public VoidResponse addLogMessageToAsset(String serverName, String userId, String guid, LogRecordRequestBody requestBody) {
        String methodName = "addLogMessageToAsset";
        log.debug("Calling method: addLogMessageToAsset");
        VoidResponse response = new VoidResponse();
        try {
            String connectorInstanceId = null;
            String connectionName = null;
            String connectorType = null;
            String contextId = null;
            String message = null;
            if (requestBody != null) {
                connectorInstanceId = requestBody.getConnectorInstanceId();
                connectionName = requestBody.getConnectionName();
                connectorType = requestBody.getConnectorType();
                contextId = requestBody.getContextId();
                message = requestBody.getMessage();
            }
            AuditLogHandler auditLogHandler = new AuditLogHandler(instanceHandler.getAccessServiceName(), instanceHandler.getAuditLog(serverName));
            auditLogHandler.addLogMessageToAsset(userId, guid, connectorInstanceId, connectionName, connectorType, contextId, message);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addLogMessageToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse createPublicTag(String serverName, String userId, TagRequestBody requestBody) {
        String methodName = "createPublicTag";
        log.debug("Calling method: createPublicTag");
        GUIDResponse response = new GUIDResponse();
        try {
            String tagName = null;
            String tagDescription = null;
            if (requestBody != null) {
                tagName = requestBody.getTagName();
                tagDescription = requestBody.getTagDescription();
            }
            TaggingHandler taggingHandler = new TaggingHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(taggingHandler.createPublicTag(userId, tagName, tagDescription));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: createPublicTag with response: " + response.toString());
        return response;
    }

    public GUIDResponse createPrivateTag(String serverName, String userId, TagRequestBody requestBody) {
        String methodName = "createPrivateTag";
        log.debug("Calling method: createPrivateTag");
        GUIDResponse response = new GUIDResponse();
        try {
            String tagName = null;
            String tagDescription = null;
            if (requestBody != null) {
                tagName = requestBody.getTagName();
                tagDescription = requestBody.getTagDescription();
            }
            TaggingHandler taggingHandler = new TaggingHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(taggingHandler.createPrivateTag(userId, tagName, tagDescription));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: createPrivateTag with response: " + response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String userId, String tagGUID, TagRequestBody requestBody) {
        String methodName = "updateTagDescription";
        log.debug("Calling method: updateTagDescription");
        VoidResponse response = new VoidResponse();
        try {
            String tagDescription = null;
            if (requestBody != null) {
                tagDescription = requestBody.getTagDescription();
            }
            TaggingHandler taggingHandler = new TaggingHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            taggingHandler.updateTagDescription(userId, tagGUID, tagDescription);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: updateTagDescription with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String userId, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTag";
        log.debug("Calling method: removeTag");
        VoidResponse response = new VoidResponse();
        try {
            TaggingHandler taggingHandler = new TaggingHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            taggingHandler.deleteTag(userId, tagGUID);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeTag with response: " + response.toString());
        return response;
    }

    public TagResponse getTag(String serverName, String userId, String guid) {
        String methodName = "getTag";
        log.debug("Calling method: getTag");
        TagResponse response = new TagResponse();
        try {
            TaggingHandler taggingHandler = new TaggingHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setTag(taggingHandler.getTag(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getTag with response: " + response.toString());
        return response;
    }

    public TagListResponse getTagsByName(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        log.debug("Calling method: getTagsByName");
        TagListResponse response = new TagListResponse();
        try {
            TaggingHandler taggingHandler = new TaggingHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setTags(taggingHandler.getTagsByName(userId, tagName, startFrom, pageSize));
            response.setStartingFromElement(startFrom);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getTagsByName with response: " + response.toString());
        return response;
    }

    public VoidResponse addTagToAsset(String serverName, String userId, String assetGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "addTagToAsset";
        log.debug("Calling method: addTagToAsset");
        VoidResponse response = new VoidResponse();
        try {
            TaggingHandler taggingHandler = new TaggingHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            taggingHandler.addTagToAsset(userId, assetGUID, tagGUID);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addTagToAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse removeTagFromAsset(String serverName, String userId, String assetGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromAsset";
        log.debug("Calling method: removeTagFromAsset");
        VoidResponse response = new VoidResponse();
        try {
            TaggingHandler taggingHandler = new TaggingHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            taggingHandler.addTagToAsset(userId, assetGUID, tagGUID);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeTagFromAsset with response: " + response.toString());
        return response;
    }

    private void captureCheckedException(AssetConsumerOMASAPIResponse response, AssetConsumerCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureCheckedException(AssetConsumerOMASAPIResponse response, AssetConsumerCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
    }

    private void captureAmbiguousConnectionNameException(AssetConsumerOMASAPIResponse response, AmbiguousConnectionNameException error) {
        String connectionName = error.getConnectionName();
        if (connectionName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("connectionName", connectionName);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureInvalidParameterException(AssetConsumerOMASAPIResponse response, InvalidParameterException error) {
        String parameterName = error.getParameterName();
        if (parameterName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", parameterName);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void capturePropertyServerException(AssetConsumerOMASAPIResponse response, PropertyServerException error) {
        this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureNoConnectedAssetException(AssetConsumerOMASAPIResponse response, NoConnectedAssetException error) {
        String connectionGUID = error.getConnectionGUID();
        if (connectionGUID != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("connectionGUID", connectionGUID);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureUserNotAuthorizedException(AssetConsumerOMASAPIResponse response, UserNotAuthorizedException error) {
        String userId = error.getUserId();
        if (userId != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("userId", userId);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }
}

