/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerServicesInstanceMap;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetConsumerServicesInstance {
    private List<String> supportedZones;
    private OMRSRepositoryConnector repositoryConnector;
    private OMRSMetadataCollection metadataCollection;
    private String serverName;
    private OMRSAuditLog auditLog;

    public AssetConsumerServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, OMRSAuditLog auditLog) throws NewInstanceException {
        String methodName = "new ServiceInstance";
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.serverName = repositoryConnector.getServerName();
                this.metadataCollection = repositoryConnector.getMetadataCollection();
                this.supportedZones = supportedZones;
                this.auditLog = auditLog;
                AssetConsumerServicesInstanceMap.setNewInstanceForJVM(this.serverName, this);
            }
            catch (Throwable error) {
                AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.OMRS_NOT_INITIALIZED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
                throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public List<String> getSupportedZones() {
        return this.supportedZones;
    }

    public OMRSAuditLog getAuditLog() {
        return this.auditLog;
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getServerName"});
        throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getServerName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public OMRSMetadataCollection getMetadataCollection() throws PropertyServerException {
        String methodName = "getMetadataCollection";
        if (this.repositoryConnector != null && this.metadataCollection != null && this.repositoryConnector.isActive()) {
            return this.metadataCollection;
        }
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getMetadataCollection"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public OMRSRepositoryConnector getRepositoryConnector() throws PropertyServerException {
        String methodName = "getRepositoryConnector";
        if (this.repositoryConnector != null && this.metadataCollection != null && this.repositoryConnector.isActive()) {
            return this.repositoryConnector;
        }
        AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void shutdown() {
        AssetConsumerServicesInstanceMap.removeInstanceForJVM(this.serverName);
    }
}

