/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.auditlog;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AssetConsumerAuditCode {
    SERVICE_INITIALIZING("OMAS-ASSET-CONSUMER-0001", OMRSAuditLogRecordSeverity.INFO, "The Asset Consumer Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Consumer OMAS.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("OMAS-ASSET-CONSUMER-0003", OMRSAuditLogRecordSeverity.INFO, "The Asset Consumer Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OMAS-ASSET-CONSUMER-0004", OMRSAuditLogRecordSeverity.INFO, "The Asset Consumer Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Asset Consumer OMAS instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-CONSUMER-0005", OMRSAuditLogRecordSeverity.ERROR, "The Asset Consumer Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    ASSET_AUDIT_LOG("OMAS-ASSET-CONSUMER-0008", OMRSAuditLogRecordSeverity.INFO, "Log message for asset {0}: {1}", "An asset consumer has logged a message for an asset.", "Review the message to ensure no action is required.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private AssetConsumerAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("<== AssetConsumer Audit Code.getMessage(%s)", Arrays.toString(params)));
        }
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        if (log.isDebugEnabled()) {
            log.debug(String.format("==> AssetConsumer Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        }
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(AssetConsumerAuditCode.class);
    }
}

