/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerGlossaryInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.builders.GlossaryTermBuilder;
import org.odpi.openmetadata.accessservices.assetconsumer.converters.GlossaryTermConverter;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.GlossaryTerm;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryHandler
implements AssetConsumerGlossaryInterface {
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;

    public GlossaryHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
    }

    public List<GlossaryTerm> getMeaningByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMeaningsByName";
        String nameParameter = "name";
        ArrayList<GlossaryTerm> results = new ArrayList<GlossaryTerm>();
        this.invalidParameterHandler.validateUserId(userId, "getMeaningsByName");
        this.invalidParameterHandler.validateName(name, "name", "getMeaningsByName");
        GlossaryTermBuilder glossaryTermBuilder = new GlossaryTermBuilder(name, name, this.repositoryHelper, this.serviceName, this.serverName);
        List glossaryTerms = this.repositoryHandler.getEntityByName(userId, glossaryTermBuilder.getNameInstanceProperties("getMeaningsByName"), "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "getMeaningsByName");
        if (glossaryTerms != null) {
            for (EntityDetail entity : glossaryTerms) {
                if (entity == null) continue;
                GlossaryTermConverter converter = new GlossaryTermConverter(entity, this.repositoryHelper, this.serviceName);
                results.add(converter.getBean());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public GlossaryTerm getMeaning(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMeaningByGUID";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getMeaningByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getMeaningByGUID");
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, guid, "guid", "GlossaryTerm", "getMeaningByGUID");
        GlossaryTermConverter converter = new GlossaryTermConverter(entity, this.repositoryHelper, this.serviceName);
        return converter.getBean();
    }
}

