/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.GlossaryHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.LoggingHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetConsumerServicesInstance
extends OCFOMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.ASSET_CONSUMER_OMAS;
    private GlossaryHandler glossaryHandler;
    private LoggingHandler loggingHandler;

    public AssetConsumerServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, OMRSAuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceName() + " OMAS", repositoryConnector, supportedZones, null, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.glossaryHandler = new GlossaryHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler);
        this.loggingHandler = new LoggingHandler(auditLog);
    }

    GlossaryHandler getGlossaryHandler() {
        return this.glossaryHandler;
    }

    LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }
}

