/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.LoggingHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.FeedbackRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.GlossaryTermListResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.GlossaryTermResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RatingRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagsResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetConsumerRESTServices {
    private static AssetConsumerInstanceHandler instanceHandler = new AssetConsumerInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(AssetConsumerRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse getAssetForConnectionName(String serverName, String userId, String connectionName) {
        String methodName = "getAssetForConnectionName";
        log.debug("Calling method: getAssetForConnectionName");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetForConnectionName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetForConnectionName");
            response.setGUID(handler.getAssetForConnectionName(userId, connectionName, "getAssetForConnectionName"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssetForConnectionName", auditLog);
        }
        log.debug("Returning from method: getAssetForConnectionName with response: " + response.toString());
        return response;
    }

    private List<String> getGUIDs(List<Asset> assets) {
        if (assets != null && !assets.isEmpty()) {
            ArrayList<String> results = new ArrayList<String>();
            for (Asset asset : assets) {
                String guid;
                if (asset == null || (guid = asset.getGUID()) == null) continue;
                results.add(guid);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public GUIDListResponse findAssets(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findAssets";
        log.debug("Calling method: findAssets");
        GUIDListResponse response = new GUIDListResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            response.setGUIDs(this.getGUIDs(handler.findAssets(userId, searchString, startFrom, pageSize, "findAssets")));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "findAssets", auditLog);
        }
        log.debug("Returning from method: findAssets with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getAssetsByName";
        log.debug("Calling method: getAssetsByName");
        GUIDListResponse response = new GUIDListResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            response.setGUIDs(this.getGUIDs(handler.getAssetsByName(userId, name, startFrom, pageSize, "getAssetsByName")));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssetsByName", auditLog);
        }
        log.debug("Returning from method: getAssetsByName with response: " + response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByName(String serverName, String userId, String name) {
        String methodName = "getConnectionByName";
        log.debug("Calling method: getConnectionByName");
        ConnectionResponse response = new ConnectionResponse();
        OMRSAuditLog auditLog = null;
        try {
            ConnectionHandler connectionHandler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByName");
            response.setConnection(connectionHandler.getConnectionByName(userId, name, "getConnectionByName"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getConnectionByName", auditLog);
        }
        log.debug("Returning from method: getConnectionByName with response: " + response.toString());
        return response;
    }

    public VoidResponse addRatingToAsset(String serverName, String userId, String guid, RatingRequestBody requestBody) {
        String methodName = "addRatingToAsset";
        log.debug("Calling method: addRatingToAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addRatingToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToAsset");
                handler.addRatingToAsset(userId, guid, requestBody.getStarRating(), requestBody.getReview(), requestBody.isPublic(), "addRatingToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addRatingToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addRatingToAsset", auditLog);
        }
        log.debug("Returning from method: addRatingToAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse removeRatingFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRatingFromAsset";
        log.debug("Calling method: removeRatingFromAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeRatingFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromAsset");
            handler.removeRatingFromAsset(userId, guid, "removeRatingFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "removeRatingFromAsset", auditLog);
        }
        log.debug("Returning from method: removeRatingFromAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse addLikeToAsset(String serverName, String userId, String guid, FeedbackRequestBody requestBody) {
        String methodName = "addLikeToAsset";
        log.debug("Calling method: addLikeToAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addLikeToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToAsset");
                handler.addLikeToAsset(userId, guid, requestBody.isPublic(), "addLikeToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLikeToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addLikeToAsset", auditLog);
        }
        log.debug("Returning from method: addLikeToAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse removeLikeFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLikeFromAsset";
        log.debug("Calling method: removeLikeFromAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeLikeFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromAsset");
            handler.removeLikeFromAsset(userId, guid, "removeLikeFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "removeLikeFromAsset", auditLog);
        }
        log.debug("Returning from method: removeLikeFromAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addCommentToAsset(String serverName, String userId, String guid, CommentRequestBody requestBody) {
        String methodName = "addCommentToAsset";
        log.debug("Calling method: addCommentToAsset");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addCommentToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToAsset");
                response.setGUID(handler.addCommentToAsset(userId, guid, requestBody.getCommentType(), requestBody.getCommentText(), requestBody.isPublic(), "addCommentToAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addCommentToAsset", auditLog);
        }
        log.debug("Returning from method: addCommentToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String userId, String assetGUID, String commentGUID, CommentRequestBody requestBody) {
        String methodName = "addCommentReply";
        log.debug("Calling method: addCommentReply");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addCommentReply");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentReply");
                response.setGUID(handler.addCommentReply(userId, assetGUID, commentGUID, requestBody.getCommentType(), requestBody.getCommentText(), requestBody.isPublic(), "addCommentReply"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addCommentReply", auditLog);
        }
        log.debug("Returning from method: addCommentReply with response: " + response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String userId, String assetGUID, String commentGUID, CommentRequestBody requestBody) {
        String methodName = "updateComment";
        log.debug("Calling method: updateComment");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "updateComment");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
                handler.updateAssetComment(userId, assetGUID, commentGUID, requestBody.getCommentType(), requestBody.getCommentText(), requestBody.isPublic(), "updateComment");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateComment", auditLog);
        }
        log.debug("Returning from method: updateComment with response: " + response.toString());
        return response;
    }

    public VoidResponse removeCommentFromAsset(String serverName, String userId, String assetGUID, String commentGUID, NullRequestBody requestBody) {
        String methodName = "removeAssetComment";
        log.debug("Calling method: removeAssetComment");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeAssetComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAssetComment");
            handler.removeAssetComment(userId, assetGUID, commentGUID, "removeAssetComment");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "removeAssetComment", auditLog);
        }
        log.debug("Returning from method: removeAssetComment with response: " + response.toString());
        return response;
    }

    public GlossaryTermResponse getMeaning(String serverName, String userId, String guid) {
        String methodName = "getMeaning";
        log.debug("Calling method: getMeaning");
        GlossaryTermResponse response = new GlossaryTermResponse();
        OMRSAuditLog auditLog = null;
        try {
            GlossaryTermHandler glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaning");
            response.setGlossaryTerm(glossaryTermHandler.getMeaning(userId, guid, "getMeaning"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getMeaning", auditLog);
        }
        log.debug("Returning from method: getMeaning with response: " + response.toString());
        return response;
    }

    public GlossaryTermListResponse getMeaningByName(String serverName, String userId, String term, int startFrom, int pageSize) {
        String methodName = "getMeaningByName";
        log.debug("Calling method: getMeaningByName");
        GlossaryTermListResponse response = new GlossaryTermListResponse();
        OMRSAuditLog auditLog = null;
        try {
            GlossaryTermHandler glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaningByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaningByName");
            response.setMeanings(glossaryTermHandler.getMeaningByName(userId, term, startFrom, pageSize, "getMeaningByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getMeaningByName", auditLog);
        }
        log.debug("Returning from method: getMeaningByName with response: " + response.toString());
        return response;
    }

    public GlossaryTermListResponse findMeanings(String serverName, String userId, String term, int startFrom, int pageSize) {
        String methodName = "findMeanings";
        log.debug("Calling method: findMeanings");
        GlossaryTermListResponse response = new GlossaryTermListResponse();
        OMRSAuditLog auditLog = null;
        try {
            GlossaryTermHandler glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "findMeanings");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMeanings");
            response.setMeanings(glossaryTermHandler.findMeanings(userId, term, startFrom, pageSize, "findMeanings"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "findMeanings", auditLog);
        }
        log.debug("Returning from method: findMeanings with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByMeaning(String serverName, String userId, String termGUID, int startFrom, int pageSize) {
        String methodName = "getAssetsByMeaning";
        log.debug("Calling method: getAssetsByMeaning");
        GUIDListResponse response = new GUIDListResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByMeaning");
            response.setGUIDs(handler.getAssetsByMeaning(userId, termGUID, startFrom, pageSize, "getAssetsByMeaning"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssetsByMeaning", auditLog);
        }
        log.debug("Returning from method: getAssetsByMeaning with response: " + response.toString());
        return response;
    }

    public VoidResponse addLogMessageToAsset(String serverName, String userId, String guid, LogRecordRequestBody requestBody) {
        String methodName = "addLogMessageToAsset";
        log.debug("Calling method: addLogMessageToAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LoggingHandler loggingHandler = instanceHandler.getLoggingHandler(userId, serverName, "addLogMessageToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLogMessageToAsset");
                loggingHandler.addLogMessageToAsset(userId, guid, requestBody.getConnectorInstanceId(), requestBody.getConnectionName(), requestBody.getConnectorType(), requestBody.getContextId(), requestBody.getMessage());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLogMessageToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addLogMessageToAsset", auditLog);
        }
        log.debug("Returning from method: addLogMessageToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse createTag(String serverName, String userId, TagRequestBody requestBody) {
        String methodName = "createTag";
        log.debug("Calling method: createTag");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createTag(userId, requestBody.getTagName(), requestBody.getTagDescription(), requestBody.isPublic(), "createTag"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createTag", auditLog);
        }
        log.debug("Returning from method: createTag with response: " + response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String userId, String tagGUID, TagRequestBody requestBody) {
        String methodName = "updateTagDescription";
        log.debug("Calling method: updateTagDescription");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, tagGUID, requestBody.getTagDescription(), "updateTagDescription");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateTagDescription", auditLog);
        }
        log.debug("Returning from method: updateTagDescription with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String userId, String tagGUID, NullRequestBody requestBody) {
        String methodName = "deleteTag";
        log.debug("Calling method: deleteTag");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            handler.deleteTag(userId, tagGUID, "deleteTag");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "deleteTag", auditLog);
        }
        log.debug("Returning from method: deleteTag with response: " + response.toString());
        return response;
    }

    public TagResponse getTag(String serverName, String userId, String guid) {
        String methodName = "getTag";
        log.debug("Calling method: getTag");
        TagResponse response = new TagResponse();
        OMRSAuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            response.setTag(handler.getTag(userId, guid, "getTag"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getTag", auditLog);
        }
        log.debug("Returning from method: getTag with response: " + response.toString());
        return response;
    }

    public TagsResponse getTagsByName(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        log.debug("Calling method: getTagsByName");
        TagsResponse response = new TagsResponse();
        OMRSAuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            response.setTags(handler.getTagsByName(userId, tagName, startFrom, pageSize, "getTagsByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getTagsByName", auditLog);
        }
        log.debug("Returning from method: getTagsByName with response: " + response.toString());
        return response;
    }

    public TagsResponse getMyTagsByName(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "getMyTagsByName";
        log.debug("Calling method: getMyTagsByName");
        TagsResponse response = new TagsResponse();
        OMRSAuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            response.setTags(handler.getMyTagsByName(userId, tagName, startFrom, pageSize, "getMyTagsByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getMyTagsByName", auditLog);
        }
        log.debug("Returning from method: getMyTagsByName with response: " + response.toString());
        return response;
    }

    public TagsResponse findTags(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "findTags";
        log.debug("Calling method: findTags");
        TagsResponse response = new TagsResponse();
        OMRSAuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            response.setTags(handler.findTags(userId, tagName, startFrom, pageSize, "findTags"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "findTags", auditLog);
        }
        log.debug("Returning from method: findTags with response: " + response.toString());
        return response;
    }

    public TagsResponse findMyTags(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "findMyTags";
        log.debug("Calling method: findMyTags");
        TagsResponse response = new TagsResponse();
        OMRSAuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            response.setTags(handler.findMyTags(userId, tagName, startFrom, pageSize, "findMyTags"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "findMyTags", auditLog);
        }
        log.debug("Returning from method: findMyTags with response: " + response.toString());
        return response;
    }

    public VoidResponse addTagToAsset(String serverName, String userId, String assetGUID, String tagGUID, FeedbackRequestBody requestBody) {
        String methodName = "addTagToAsset";
        log.debug("Calling method: addTagToAsset");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.isPublic();
        }
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addTagToAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToAsset");
            handler.addTagToAsset(userId, assetGUID, tagGUID, isPublic, "addTagToAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addTagToAsset", auditLog);
        }
        log.debug("Returning from method: addTagToAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse removeTagFromAsset(String serverName, String userId, String assetGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromAsset";
        log.debug("Calling method: removeTagFromAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeTagFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromAsset");
            handler.removeTagFromAsset(userId, assetGUID, tagGUID, "removeTagFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "removeTagFromAsset", auditLog);
        }
        log.debug("Returning from method: removeTagFromAsset with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByTag(String serverName, String userId, String tagGUID, int startFrom, int pageSize) {
        String methodName = "getAssetsByTag";
        log.debug("Calling method: getAssetsByTag");
        GUIDListResponse response = new GUIDListResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByTag");
            response.setGUIDs(handler.getAssetsByTag(userId, tagGUID, startFrom, pageSize, "getAssetsByTag"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssetsByTag", auditLog);
        }
        log.debug("Returning from method: getAssetsByTag with response: " + response.toString());
        return response;
    }
}

