/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import org.odpi.openmetadata.accessservices.assetconsumer.handlers.LoggingHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.FeedbackRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.GlossaryTermListResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.GlossaryTermResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RatingRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagsResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class AssetConsumerRESTServices {
    private static AssetConsumerInstanceHandler instanceHandler = new AssetConsumerInstanceHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetConsumerRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse getAssetForConnectionName(String serverName, String userId, String connectionName) {
        String methodName = "getAssetForConnectionName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetForConnectionName");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetForConnectionName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetForConnectionName");
            response.setGUID(handler.getAssetForConnectionName(userId, connectionName, "getAssetForConnectionName"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAssetForConnectionName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse findAssets(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            response.setGUIDs(handler.findAssetGUIDs(userId, searchString, startFrom, pageSize, "findAssets"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            response.setGUIDs(handler.getAssetGUIDsByName(userId, name, startFrom, pageSize, "getAssetsByName"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByName(String serverName, String userId, String name) {
        String methodName = "getConnectionByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionByName");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            ConnectionHandler connectionHandler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByName");
            response.setConnection(connectionHandler.getConnectionByName(userId, name, "getConnectionByName"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getConnectionByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addRatingToAsset(String serverName, String userId, String guid, RatingRequestBody requestBody) {
        String methodName = "addRatingToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addRatingToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addRatingToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToAsset");
                handler.addRatingToAsset(userId, guid, requestBody.getStarRating(), requestBody.getReview(), requestBody.isPublic(), "addRatingToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addRatingToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addRatingToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeRatingFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRatingFromAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeRatingFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeRatingFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromAsset");
            handler.removeRatingFromAsset(userId, guid, "removeRatingFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeRatingFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLikeToAsset(String serverName, String userId, String guid, FeedbackRequestBody requestBody) {
        String methodName = "addLikeToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLikeToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addLikeToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToAsset");
                handler.addLikeToAsset(userId, guid, requestBody.isPublic(), "addLikeToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLikeToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addLikeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLikeFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLikeFromAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeLikeFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeLikeFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromAsset");
            handler.removeLikeFromAsset(userId, guid, "removeLikeFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeLikeFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentToAsset(String serverName, String userId, String guid, CommentRequestBody requestBody) {
        String methodName = "addCommentToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addCommentToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToAsset");
                response.setGUID(handler.addCommentToAsset(userId, guid, requestBody.getCommentType(), requestBody.getCommentText(), requestBody.isPublic(), "addCommentToAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addCommentToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String userId, String assetGUID, String commentGUID, CommentRequestBody requestBody) {
        String methodName = "addCommentReply";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentReply");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addCommentReply");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentReply");
                response.setGUID(handler.addCommentReply(userId, assetGUID, commentGUID, requestBody.getCommentType(), requestBody.getCommentText(), requestBody.isPublic(), "addCommentReply"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addCommentReply", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String userId, String assetGUID, String commentGUID, CommentRequestBody requestBody) {
        String methodName = "updateComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "updateComment");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
                handler.updateAssetComment(userId, assetGUID, commentGUID, requestBody.getCommentType(), requestBody.getCommentText(), requestBody.isPublic(), "updateComment");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommentFromAsset(String serverName, String userId, String assetGUID, String commentGUID, NullRequestBody requestBody) {
        String methodName = "removeAssetComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAssetComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeAssetComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAssetComment");
            handler.removeAssetComment(userId, assetGUID, commentGUID, "removeAssetComment");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeAssetComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermResponse getMeaning(String serverName, String userId, String guid) {
        String methodName = "getMeaning";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeaning");
        GlossaryTermResponse response = new GlossaryTermResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaning");
            response.setGlossaryTerm(glossaryTermHandler.getMeaning(userId, guid, "getMeaning"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getMeaning", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermListResponse getMeaningByName(String serverName, String userId, String term, int startFrom, int pageSize) {
        String methodName = "getMeaningByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeaningByName");
        GlossaryTermListResponse response = new GlossaryTermListResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaningByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaningByName");
            response.setMeanings(glossaryTermHandler.getMeaningByName(userId, term, startFrom, pageSize, "getMeaningByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getMeaningByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermListResponse findMeanings(String serverName, String userId, String term, int startFrom, int pageSize) {
        String methodName = "findMeanings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMeanings");
        GlossaryTermListResponse response = new GlossaryTermListResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "findMeanings");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMeanings");
            response.setMeanings(glossaryTermHandler.findMeanings(userId, term, startFrom, pageSize, "findMeanings"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findMeanings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByMeaning(String serverName, String userId, String termGUID, int startFrom, int pageSize) {
        String methodName = "getAssetsByMeaning";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByMeaning");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByMeaning");
            response.setGUIDs(handler.getAssetsByMeaning(userId, termGUID, startFrom, pageSize, "getAssetsByMeaning"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAssetsByMeaning", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLogMessageToAsset(String serverName, String userId, String guid, LogRecordRequestBody requestBody) {
        String methodName = "addLogMessageToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLogMessageToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LoggingHandler loggingHandler = instanceHandler.getLoggingHandler(userId, serverName, "addLogMessageToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLogMessageToAsset");
                loggingHandler.addLogMessageToAsset(userId, guid, requestBody.getConnectorInstanceId(), requestBody.getConnectionName(), requestBody.getConnectorType(), requestBody.getContextId(), requestBody.getMessage());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLogMessageToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addLogMessageToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createTag(String serverName, String userId, TagRequestBody requestBody) {
        String methodName = "createTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTag");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createTag(userId, requestBody.getTagName(), requestBody.getTagDescription(), requestBody.isPublic(), "createTag"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String userId, String tagGUID, TagRequestBody requestBody) {
        String methodName = "updateTagDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTagDescription");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, tagGUID, requestBody.getTagDescription(), "updateTagDescription");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateTagDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String userId, String tagGUID, NullRequestBody requestBody) {
        String methodName = "deleteTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            handler.deleteTag(userId, tagGUID, "deleteTag");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "deleteTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagResponse getTag(String serverName, String userId, String guid) {
        String methodName = "getTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTag");
        TagResponse response = new TagResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            response.setTag(handler.getTag(userId, guid, "getTag"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagsResponse getTagsByName(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTagsByName");
        TagsResponse response = new TagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            response.setTags(handler.getTagsByName(userId, tagName, startFrom, pageSize, "getTagsByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagsResponse getMyTagsByName(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "getMyTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMyTagsByName");
        TagsResponse response = new TagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            response.setTags(handler.getMyTagsByName(userId, tagName, startFrom, pageSize, "getMyTagsByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getMyTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagsResponse findTags(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "findTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTags");
        TagsResponse response = new TagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            response.setTags(handler.findTags(userId, tagName, startFrom, pageSize, "findTags"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagsResponse findMyTags(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "findMyTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMyTags");
        TagsResponse response = new TagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            response.setTags(handler.findMyTags(userId, tagName, startFrom, pageSize, "findMyTags"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToAsset(String serverName, String userId, String assetGUID, String tagGUID, FeedbackRequestBody requestBody) {
        String methodName = "addTagToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToAsset");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.isPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addTagToAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToAsset");
            handler.addTagToAsset(userId, assetGUID, tagGUID, isPublic, "addTagToAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addTagToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromAsset(String serverName, String userId, String assetGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeTagFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromAsset");
            handler.removeTagFromAsset(userId, assetGUID, tagGUID, "removeTagFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeTagFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByTag(String serverName, String userId, String tagGUID, int startFrom, int pageSize) {
        String methodName = "getAssetsByTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByTag");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByTag");
            response.setGUIDs(handler.getAssetsByTag(userId, tagGUID, startFrom, pageSize, "getAssetsByTag"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAssetsByTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

