/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import org.odpi.openmetadata.accessservices.assetconsumer.elements.AssetElement;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.CommentElement;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.InformalTagElement;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.LikeElement;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.MeaningElement;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.RatingElement;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.LoggingHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.CommentProperties;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.CommentType;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.InformalTagProperties;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.RatingProperties;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.StarRating;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.FeedbackRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GlossaryTermListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GlossaryTermResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagsResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CommentHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.generichandlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LikeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RatingHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class AssetConsumerRESTServices {
    private static AssetConsumerInstanceHandler instanceHandler = new AssetConsumerInstanceHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetConsumerRESTServices.class), instanceHandler.getServiceName());

    public ConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getAssetForConnectionName(String serverName, String userId, String connectionName) {
        String connectionNameParameterName = "connectionName";
        String methodName = "getAssetForConnectionName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetForConnectionName");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetForConnectionName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetForConnectionName");
            response.setGUID(handler.getAssetForConnectionName(userId, connectionName, "connectionName", "getAssetForConnectionName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAssetForConnectionName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse findAssets(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String searchStringParameter = "searchString";
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            response.setGUIDs(handler.findAssetGUIDs(userId, searchString, "searchString", startFrom, pageSize, "findAssets"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String nameParameterName = "name";
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            response.setGUIDs(handler.getAssetGUIDsByName(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", name, "name", startFrom, pageSize, "getAssetsByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addRatingToAsset(String serverName, String userId, String guid, RatingProperties requestBody) {
        String methodName = "addRatingToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addRatingToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                RatingHandler<RatingElement> handler = instanceHandler.getRatingHandler(userId, serverName, "addRatingToAsset");
                int starRating = StarRating.NO_RECOMMENDATION.getOpenTypeOrdinal();
                if (requestBody.getStarRating() != null) {
                    starRating = requestBody.getStarRating().getOpenTypeOrdinal();
                }
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToAsset");
                handler.saveRating(userId, null, null, guid, "guid", starRating, requestBody.getReview(), requestBody.isPublic(), "addRatingToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addRatingToAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addRatingToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeRatingFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRatingFromAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeRatingFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            RatingHandler<RatingElement> handler = instanceHandler.getRatingHandler(userId, serverName, "removeRatingFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromAsset");
            handler.removeRating(userId, null, null, guid, "guid", "removeRatingFromAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeRatingFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLikeToAsset(String serverName, String userId, String guid, FeedbackRequestBody requestBody) {
        String methodName = "addLikeToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLikeToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LikeHandler<LikeElement> handler = instanceHandler.getLikeHandler(userId, serverName, "addLikeToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToAsset");
                handler.saveLike(userId, null, null, guid, "guid", requestBody.getIsPublic(), "addLikeToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLikeToAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addLikeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLikeFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLikeFromAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeLikeFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            LikeHandler<LikeElement> handler = instanceHandler.getLikeHandler(userId, serverName, "removeLikeFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromAsset");
            handler.removeLike(userId, null, null, guid, "guid", "removeLikeFromAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeLikeFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentToAsset(String serverName, String userId, String guid, CommentProperties requestBody) {
        String methodName = "addCommentToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOpenTypeOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOpenTypeOrdinal();
                }
                CommentHandler<CommentElement> handler = instanceHandler.getCommentHandler(userId, serverName, "addCommentToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToAsset");
                response.setGUID(handler.attachNewComment(userId, null, null, guid, guid, "guid", commentType, requestBody.getCommentText(), requestBody.getIsPublic(), "addCommentToAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentToAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addCommentToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String userId, String assetGUID, String commentGUID, CommentProperties requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "addCommentReply";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentReply");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOpenTypeOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOpenTypeOrdinal();
                }
                CommentHandler<CommentElement> handler = instanceHandler.getCommentHandler(userId, serverName, "addCommentReply");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentReply");
                response.setGUID(handler.attachNewComment(userId, null, null, assetGUID, commentGUID, "commentGUID", commentType, requestBody.getCommentText(), requestBody.getIsPublic(), "addCommentReply"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addCommentReply", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String userId, String assetGUID, String commentGUID, CommentProperties requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "updateComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOpenTypeOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOpenTypeOrdinal();
                }
                CommentHandler<CommentElement> handler = instanceHandler.getCommentHandler(userId, serverName, "updateComment");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
                handler.updateComment(userId, null, null, commentGUID, "commentGUID", commentType, requestBody.getCommentText(), requestBody.getIsPublic(), "updateComment");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommentFromAsset(String serverName, String userId, String assetGUID, String commentGUID, NullRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "removeAssetComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAssetComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CommentHandler<CommentElement> handler = instanceHandler.getCommentHandler(userId, serverName, "removeAssetComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAssetComment");
            handler.removeCommentFromElement(userId, null, null, commentGUID, "commentGUID", "removeAssetComment");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeAssetComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermResponse getMeaning(String serverName, String userId, String guid) {
        String guidParameterName = "guid";
        String methodName = "getMeaning";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeaning");
        GlossaryTermResponse response = new GlossaryTermResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaning");
            response.setMeaning((MeaningElement)glossaryTermHandler.getTerm(userId, guid, "guid", "getMeaning"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getMeaning", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermListResponse getMeaningByName(String serverName, String userId, String term, int startFrom, int pageSize) {
        String nameParameterName = "term";
        String methodName = "getMeaningByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeaningByName");
        GlossaryTermListResponse response = new GlossaryTermListResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaningByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaningByName");
            response.setMeanings(glossaryTermHandler.getTermsByName(userId, term, "term", startFrom, pageSize, "getMeaningByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getMeaningByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermListResponse findMeanings(String serverName, String userId, String term, int startFrom, int pageSize) {
        String nameParameterName = "term";
        String methodName = "findMeanings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMeanings");
        GlossaryTermListResponse response = new GlossaryTermListResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "findMeanings");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMeanings");
            response.setMeanings(glossaryTermHandler.findTerms(userId, term, "term", startFrom, pageSize, "findMeanings"));
            response.setStartingFromElement(startFrom);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findMeanings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByMeaning(String serverName, String userId, String termGUID, int startFrom, int pageSize) {
        String guidParameterName = "termGUID";
        String methodName = "getAssetsByMeaning";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByMeaning");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByMeaning");
            response.setGUIDs(handler.getAttachedElementGUIDs(userId, termGUID, "termGUID", "GlossaryTerm", "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", "Asset", startFrom, pageSize, "getAssetsByMeaning"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAssetsByMeaning", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLogMessageToAsset(String serverName, String userId, String guid, LogRecordRequestBody requestBody) {
        String methodName = "addLogMessageToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLogMessageToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LoggingHandler loggingHandler = instanceHandler.getLoggingHandler(userId, serverName, "addLogMessageToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLogMessageToAsset");
                loggingHandler.addLogMessageToAsset(userId, guid, requestBody.getConnectorInstanceId(), requestBody.getConnectionName(), requestBody.getConnectorType(), requestBody.getContextId(), requestBody.getMessage());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLogMessageToAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addLogMessageToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createTag(String serverName, String userId, InformalTagProperties requestBody) {
        String methodName = "createTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTag");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createTag(userId, null, null, requestBody.getName(), requestBody.getDescription(), !requestBody.getIsPrivateTag(), "createTag"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String userId, String tagGUID, InformalTagProperties requestBody) {
        String methodName = "updateTagDescription";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTagDescription");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, null, null, tagGUID, "tagGUID", requestBody.getDescription(), "updateTagDescription");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateTagDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String userId, String tagGUID, NullRequestBody requestBody) {
        String methodName = "deleteTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            handler.deleteTag(userId, null, null, tagGUID, "tagGUID", "deleteTag");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagResponse getTag(String serverName, String userId, String guid) {
        String methodName = "getTag";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTag");
        TagResponse response = new TagResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            response.setTag((InformalTagElement)handler.getTag(userId, guid, "guid", "getTag"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagsResponse getTagsByName(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTagsByName");
        TagsResponse response = new TagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            response.setTags(handler.getTagsByName(userId, tagName, "tagName", startFrom, pageSize, "getTagsByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagsResponse getMyTagsByName(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "getMyTagsByName";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMyTagsByName");
        TagsResponse response = new TagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            response.setTags(handler.getMyTagsByName(userId, tagName, "tagName", startFrom, pageSize, "getMyTagsByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getMyTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagsResponse findTags(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "findTags";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTags");
        TagsResponse response = new TagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            response.setTags(handler.findTags(userId, tagName, "tagName", startFrom, pageSize, "findTags"));
            response.setStartingFromElement(startFrom);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TagsResponse findMyTags(String serverName, String userId, String tagName, int startFrom, int pageSize) {
        String methodName = "findMyTags";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMyTags");
        TagsResponse response = new TagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            response.setTags(handler.findMyTags(userId, tagName, "tagName", startFrom, pageSize, "findMyTags"));
            response.setStartingFromElement(startFrom);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToAsset(String serverName, String userId, String assetGUID, String tagGUID, FeedbackRequestBody requestBody) {
        String methodName = "addTagToAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToAsset");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "addTagToAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToAsset");
            handler.addTagToElement(userId, null, null, assetGUID, "assetGUID", "Asset", tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "addTagToAsset"), isPublic, "addTagToAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addTagToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToElement(String serverName, String userId, String elementGUID, String tagGUID, FeedbackRequestBody requestBody) {
        String methodName = "addTagToElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToElement");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "addTagToElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToElement");
            handler.addTagToElement(userId, null, null, elementGUID, "elementGUID", "Referenceable", tagGUID, "tagGUID", isPublic, "addTagToElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addTagToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromAsset(String serverName, String userId, String assetGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "removeTagFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromAsset");
            handler.removeTagFromElement(userId, null, null, assetGUID, "assetGUID", "Asset", tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "removeTagFromAsset"), "removeTagFromAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeTagFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromElement(String serverName, String userId, String elementGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "removeTagFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromElement");
            handler.removeTagFromElement(userId, null, null, elementGUID, "elementGUID", "Referenceable", tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "removeTagFromElement"), "removeTagFromElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeTagFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByTag(String serverName, String userId, String tagGUID, int startFrom, int pageSize) {
        String methodName = "getAssetsByTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByTag");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByTag");
            response.setGUIDs(handler.getAssetGUIDsByTag(userId, tagGUID, "tagGUID", startFrom, pageSize, "getAssetsByTag"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAssetsByTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

