/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.listener;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.events.NewAssetEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.events.UpdatedAssetEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.outtopic.AssetConsumerPublisher;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.AssetConverter;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetConsumerOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final String assetTypeName = "Asset";
    private static final Logger log = LoggerFactory.getLogger(AssetConsumerOMRSTopicListener.class);
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSRepositoryValidator repositoryValidator;
    private String componentName;
    private String serverName;
    private List<String> supportedZones;
    private AssetConsumerPublisher publisher;

    public AssetConsumerOMRSTopicListener(Connection assetConsumerOutTopic, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String componentName, String serverName, List<String> supportedZones, AuditLog auditLog) throws OMAGConfigurationErrorException {
        super(componentName, auditLog);
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.componentName = componentName;
        this.serverName = serverName;
        this.supportedZones = supportedZones;
        this.publisher = new AssetConsumerPublisher(assetConsumerOutTopic, auditLog);
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event: " + instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - ignoring event");
        } else {
            OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
            OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
            if (instanceEventOriginator != null) {
                if (instanceEventType == OMRSInstanceEventType.NEW_ENTITY_EVENT) {
                    this.processNewEntity(instanceEvent.getEntity());
                } else if (instanceEventType == OMRSInstanceEventType.UPDATED_ENTITY_EVENT) {
                    this.processUpdatedEntity(instanceEvent.getEntity(), instanceEvent.getOriginalEntity());
                }
            } else {
                log.debug("Ignored instance event - null originator");
            }
        }
    }

    private void processNewEntity(EntityDetail entity) {
        AssetConverter assetConverter;
        Asset assetBean;
        String assetType = this.getAssetType(entity);
        if (assetType != null && (assetBean = (assetConverter = new AssetConverter(entity, null, this.repositoryHelper, this.componentName, this.serverName)).getAssetBean()) != null && this.inTheZone(assetBean.getZoneMembership())) {
            NewAssetEvent event = new NewAssetEvent();
            event.setAsset(assetConverter.getAssetBean());
            event.setCreationTime(entity.getCreateTime());
            this.publisher.publishNewAssetEvent(event);
        }
    }

    private void processUpdatedEntity(EntityDetail entity, EntityDetail originalEntity) {
        AssetConverter assetConverter;
        Asset assetBean;
        String assetType = this.getAssetType(entity);
        if (assetType != null && (assetBean = (assetConverter = new AssetConverter(entity, null, this.repositoryHelper, this.componentName, this.serverName)).getAssetBean()) != null && this.inTheZone(assetBean.getZoneMembership())) {
            AssetConverter assetConverterForOriginal = new AssetConverter(originalEntity, null, this.repositoryHelper, this.componentName, this.serverName);
            UpdatedAssetEvent event = new UpdatedAssetEvent();
            event.setAsset(assetBean);
            event.setOriginalAsset(assetConverterForOriginal.getAssetBean());
            event.setUpdateTime(entity.getUpdateTime());
            this.publisher.publishUpdatedAssetEvent(event);
        }
    }

    private String getAssetType(EntityDetail entity) {
        InstanceType entityType;
        String methodName = "getAssetType";
        if (this.repositoryValidator.isATypeOf(this.componentName, (InstanceAuditHeader)entity, assetTypeName, "getAssetType") && (entityType = entity.getType()) != null) {
            return entityType.getTypeDefName();
        }
        return null;
    }

    private boolean inTheZone(List<String> assetZones) {
        if (this.supportedZones == null) {
            return true;
        }
        if (assetZones == null) {
            return true;
        }
        for (String supportedZoneName : this.supportedZones) {
            for (String assetZoneName : assetZones) {
                if (!supportedZoneName.equals(assetZoneName)) continue;
                return true;
            }
        }
        return false;
    }
}

