/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.outtopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.assetconsumer.events.AssetConsumerEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.events.NewAssetEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.events.UpdatedAssetEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetConsumerPublisher {
    private static final Logger log = LoggerFactory.getLogger(AssetConsumerPublisher.class);
    private OpenMetadataTopicConnector connector = null;

    public AssetConsumerPublisher(Connection assetConsumerOutTopic, AuditLog auditLog) throws OMAGConfigurationErrorException {
        if (assetConsumerOutTopic != null) {
            this.connector = this.getTopicConnector(assetConsumerOutTopic, auditLog);
        }
    }

    public void publishNewAssetEvent(NewAssetEvent event) {
        try {
            if (this.connector != null) {
                this.connector.sendEvent(this.getJSONPayload((AssetConsumerEvent)event));
            }
        }
        catch (Exception error) {
            log.error("Unable to publish new asset event: " + event.toString() + "; error was " + error.toString());
        }
    }

    public void publishUpdatedAssetEvent(UpdatedAssetEvent event) {
        try {
            if (this.connector != null) {
                this.connector.sendEvent(this.getJSONPayload((AssetConsumerEvent)event));
            }
        }
        catch (Exception error) {
            log.error("Unable to publish undated asset event: " + event.toString() + "; error was " + error.toString());
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, AuditLog auditLog) throws OMAGConfigurationErrorException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(topicConnection);
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connector;
            topicConnector.setAuditLog(auditLog);
            topicConnector.start();
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            log.error("Unable to create topic connector: " + error.toString());
            throw new OMAGConfigurationErrorException(AssetConsumerErrorCode.BAD_OUT_TOPIC_CONNECTION.getMessageDefinition(new String[]{topicConnection.toString(), error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    private String getJSONPayload(AssetConsumerEvent event) {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonString = null;
        try {
            jsonString = objectMapper.writeValueAsString((Object)event);
        }
        catch (Exception error) {
            log.error("Unable to create event payload: " + error.toString());
        }
        return jsonString;
    }
}

