/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.outtopic;

import org.odpi.openmetadata.accessservices.assetconsumer.connectors.outtopic.AssetConsumerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.assetconsumer.events.AssetConsumerEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.events.NewAssetEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.events.UpdatedAssetEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;

public class AssetConsumerPublisher {
    private AssetConsumerOutTopicServerConnector outTopicServerConnector;
    private AuditLog outTopicAuditLog;
    private String outTopicName;
    private final String actionDescription = "Out topic event publishing";

    public AssetConsumerPublisher(AssetConsumerOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic event publishing", AssetConsumerAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    public void publishNewAssetEvent(NewAssetEvent event) {
        String methodName = "publishNewAssetEvent";
        try {
            if (this.outTopicServerConnector != null) {
                this.outTopicServerConnector.sendEvent((AssetConsumerEvent)event);
            }
        }
        catch (Exception error) {
            this.logUnexpectedPublishingException(error, "publishNewAssetEvent");
        }
    }

    public void publishUpdatedAssetEvent(UpdatedAssetEvent event) {
        String methodName = "publishUpdatedAssetEvent";
        try {
            if (this.outTopicServerConnector != null) {
                this.outTopicServerConnector.sendEvent((AssetConsumerEvent)event);
            }
        }
        catch (Exception error) {
            this.logUnexpectedPublishingException(error, "publishUpdatedAssetEvent");
        }
    }

    private void logUnexpectedPublishingException(Exception error, String methodName) {
        if (this.outTopicAuditLog != null) {
            this.outTopicAuditLog.logException(methodName, AssetConsumerAuditCode.OUT_TOPIC_FAILURE.getMessageDefinition(new String[]{this.outTopicName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", AssetConsumerAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic event publishing", AssetConsumerAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

