/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.outtopic;

import org.odpi.openmetadata.accessservices.assetconsumer.connectors.outtopic.AssetConsumerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.assetconsumer.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetconsumer.events.AssetConsumerEventType;
import org.odpi.openmetadata.accessservices.assetconsumer.events.AssetConsumerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetConsumerOutTopicPublisher {
    private AssetConsumerOutTopicServerConnector outTopicServerConnector;
    private AuditLog outTopicAuditLog;
    private String outTopicName;
    private ElementHeaderConverter<ElementHeader> headerConverter;
    private OMRSRepositoryHelper repositoryHelper;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public AssetConsumerOutTopicPublisher(AssetConsumerOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        this.repositoryHelper = repositoryHelper;
        this.headerConverter = new ElementHeaderConverter(repositoryHelper, serviceName, serverName);
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", AssetConsumerAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    public void publishEntityEvent(EntityDetail entity, AssetConsumerEventType eventType) {
        this.publishEntityEvent(eventType, entity, null, null, null);
    }

    public void publishEntityEvent(AssetConsumerEventType eventType, EntityDetail entity, EntityDetail previousEntity, Classification newClassification, Classification previousClassification) {
        String methodName = "publishEntityEvent";
        if (this.outTopicServerConnector != null) {
            AssetConsumerOutTopicEvent event = new AssetConsumerOutTopicEvent();
            try {
                event.setEventType(eventType);
                if (entity.getUpdateTime() == null) {
                    event.setEventTime(entity.getCreateTime());
                } else {
                    event.setEventTime(entity.getUpdateTime());
                }
                event.setElementHeader(this.headerConverter.getNewBean(ElementHeader.class, entity, "publishEntityEvent"));
                event.setElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(entity.getProperties()));
                if (previousEntity != null) {
                    event.setPreviousElementHeader(this.headerConverter.getNewBean(ElementHeader.class, previousEntity, "publishEntityEvent"));
                    event.setPreviousElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousEntity.getProperties()));
                }
                if (newClassification != null) {
                    event.setClassificationName(newClassification.getName());
                }
                if (previousClassification != null) {
                    event.setClassificationName(previousClassification.getName());
                    event.setPreviousClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousClassification.getProperties()));
                }
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                this.outTopicAuditLog.logException("publishEntityEvent", AssetConsumerAuditCode.PROCESS_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.toString(), error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", AssetConsumerAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", AssetConsumerAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

