/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetconsumer.converters.AssetConsumerOMASConverter;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.InformalTagElement;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.TaggedElement;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.InformalTagProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InformalTagConverter<B>
extends AssetConsumerOMASConverter<B> {
    public InformalTagConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof InformalTagElement) {
                InstanceProperties instanceProperties;
                InformalTagElement bean = (InformalTagElement)returnBean;
                InformalTagProperties informalTagProperties = new InformalTagProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    instanceProperties = new InstanceProperties(entity.getProperties());
                    informalTagProperties.setUser(entity.getCreatedBy());
                    informalTagProperties.setName(this.removeTagName(instanceProperties));
                    informalTagProperties.setDescription(this.removeTagDescription(instanceProperties));
                    informalTagProperties.setIsPrivateTag(!this.removeIsPublic(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setInformalTagProperties(informalTagProperties);
                if (relationship != null) {
                    TaggedElement taggedElement = new TaggedElement();
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    taggedElement.setRelationshipHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
                    taggedElement.setRelatedElement(super.getElementStub(beanClass, relationship.getEntityOneProxy(), methodName));
                    taggedElement.setIsPublic(this.getIsPublic(instanceProperties));
                    bean.setTaggedElement(taggedElement);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, null, methodName);
    }
}

