/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.connectors.outtopic.AssetConsumerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.assetconsumer.connectors.outtopic.AssetConsumerOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerAuditCode;
import org.odpi.openmetadata.accessservices.assetconsumer.outtopic.AssetConsumerOMRSTopicListener;
import org.odpi.openmetadata.accessservices.assetconsumer.outtopic.AssetConsumerOutTopicPublisher;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetConsumerAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private AssetConsumerServicesInstance instance = null;
    private String serverName = null;
    private AssetConsumerOutTopicPublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", AssetConsumerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new AssetConsumerServicesInstance(repositoryConnector, supportedZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), accessServiceConfig.getAccessServiceOutTopic());
            this.serverName = this.instance.getServerName();
            Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
            if (outTopicEventBusConnection != null) {
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getServerSideOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName(), AssetConsumerOutTopicServerProvider.class.getName(), auditLog);
                AssetConsumerOutTopicServerConnector outTopicServerConnector = (AssetConsumerOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, AssetConsumerOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName(), "initialize");
                this.eventPublisher = new AssetConsumerOutTopicPublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog, repositoryConnector.getRepositoryHelper(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceName(), this.serverName);
                this.registerWithEnterpriseTopic(AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new AssetConsumerOMRSTopicListener(AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName(), serverUserName, this.eventPublisher, this.instance.getAssetHandler(), supportedZones, outTopicAuditLog), auditLog);
            }
            auditLog.logMessage("initialize", AssetConsumerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", AssetConsumerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        this.auditLog.logMessage("shutdown", AssetConsumerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

