/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.MetadataElement;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.MetadataRelationship;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class MetadataRelationshipConverter<B>
extends OCFConverter<B> {
    public MetadataRelationshipConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof MetadataElement) {
                MetadataElement bean = (MetadataElement)returnBean;
                this.setUpElementHeader((ElementHeader)bean, entity, OpenMetadataType.OPEN_METADATA_ROOT.typeName, methodName);
                bean.setProperties(this.getRemainingExtendedProperties(entity.getProperties()));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewRelationshipBean(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof MetadataRelationship) {
                MetadataRelationship bean = (MetadataRelationship)returnBean;
                this.setUpElementHeader((ElementHeader)bean, (InstanceHeader)relationship, null, methodName);
                bean.setProperties(this.getRemainingExtendedProperties(relationship.getProperties()));
                bean.setEnd1(this.getElementStub(beanClass, relationship.getEntityOneProxy(), methodName));
                bean.setEnd2(this.getElementStub(beanClass, relationship.getEntityTwoProxy(), methodName));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

