/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.LoggingHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetGraphResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetSearchMatchesListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CommentRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FeedbackRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformalTagResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformalTagsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LogRecordRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.MeaningResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MeaningsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RatingRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.TagUpdateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CommentHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.generichandlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LikeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RatingHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetSearchMatches;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformalTagElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MeaningElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.InformalTagProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class AssetConsumerRESTServices {
    private static final AssetConsumerInstanceHandler instanceHandler = new AssetConsumerInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetConsumerRESTServices.class), instanceHandler.getServiceName());

    public OCFConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        OCFConnectionResponse response = new OCFConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getAssetForConnectionName(String serverName, String userId, String connectionName) {
        String connectionNameParameterName = "connectionName";
        String methodName = "getAssetForConnectionName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetForConnectionName");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetForConnectionName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetForConnectionName");
            response.setGUID(handler.getAssetForConnectionName(userId, connectionName, "connectionName", false, false, handler.getSupportedZones(), new Date(), "getAssetForConnectionName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetForConnectionName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetGraphResponse getAssetGraph(String serverName, String userId, String assetGUID, int startFrom, int pageSize) {
        String parameterName = "assetGUID";
        String methodName = "getAssetGraph";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetGraph");
        AssetGraphResponse response = new AssetGraphResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getAssetGraph");
            ReferenceableHandler<MetadataElementSummary> metadataElementHandler = instanceHandler.getMetadataElementHandler(userId, serverName, "getAssetGraph");
            ReferenceableHandler<MetadataRelationship> metadataRelationshipHandler = instanceHandler.getMetadataRelationshipHandler(userId, serverName, "getAssetGraph");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetGraph");
            AssetElement asset = (AssetElement)assetHandler.getBeanFromRepository(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, "getAssetGraph");
            if (asset != null) {
                AssetGraph assetGraph = new AssetGraph(asset);
                HashMap<String, Relationship> receivedRelationships = new HashMap<String, Relationship>();
                List relationships = metadataRelationshipHandler.getAllAttachmentLinks(userId, asset.getElementHeader().getGUID(), "assetGUID", OpenMetadataType.ASSET.typeName, false, false, new Date(), "getAssetGraph");
                if (relationships != null) {
                    for (Relationship relationship : relationships) {
                        if (relationship == null) continue;
                        receivedRelationships.put(relationship.getGUID(), relationship);
                    }
                }
                SearchClassifications searchClassifications = new SearchClassifications();
                ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
                ClassificationCondition classificationCondition = new ClassificationCondition();
                SearchProperties searchProperties = new SearchProperties();
                ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
                PropertyCondition propertyCondition = new PropertyCondition();
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue((Object)asset.getElementHeader().getGUID());
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                propertyCondition.setProperty(OpenMetadataProperty.ANCHOR_GUID.name);
                propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                propertyCondition.setValue((InstancePropertyValue)primitivePropertyValue);
                propertyConditions.add(propertyCondition);
                searchProperties.setMatchCriteria(MatchCriteria.ALL);
                searchProperties.setConditions(propertyConditions);
                classificationCondition.setName(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
                classificationCondition.setMatchProperties(searchProperties);
                classificationConditions.add(classificationCondition);
                searchClassifications.setMatchCriteria(MatchCriteria.ALL);
                searchClassifications.setConditions(classificationConditions);
                List anchoredElements = metadataElementHandler.findBeans(userId, null, null, null, null, searchClassifications, null, null, null, false, false, startFrom, pageSize, assetHandler.getSupportedZones(), new Date(), "getAssetGraph");
                assetGraph.setAnchoredElements(anchoredElements);
                if (anchoredElements != null) {
                    String anchoredElementParameterName = "anchoredElement.getGUID";
                    for (MetadataElementSummary metadataElement : anchoredElements) {
                        if (metadataElement == null || (relationships = metadataRelationshipHandler.getAllAttachmentLinks(userId, metadataElement.getElementHeader().getGUID(), "anchoredElement.getGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, new Date(), "getAssetGraph")) == null) continue;
                        for (Relationship relationship : relationships) {
                            if (relationship == null) continue;
                            receivedRelationships.put(relationship.getGUID(), relationship);
                        }
                    }
                }
                if (!receivedRelationships.isEmpty()) {
                    OpenMetadataAPIGenericConverter converter = metadataRelationshipHandler.getConverter();
                    ArrayList<MetadataRelationship> metadataRelationships = new ArrayList<MetadataRelationship>();
                    for (Relationship relationship : receivedRelationships.values()) {
                        if (relationship == null) continue;
                        MetadataRelationship metadataRelationship = (MetadataRelationship)converter.getNewRelationshipBean(MetadataRelationship.class, relationship, "getAssetGraph");
                        metadataRelationships.add(metadataRelationship);
                    }
                    assetGraph.setRelationships(metadataRelationships);
                }
                response.setAssetGraph(assetGraph);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetSearchMatchesListResponse findAssetsInDomain(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        AssetSearchMatchesListResponse response;
        RESTCallToken token;
        block9: {
            String methodName = "findAssetsInDomain";
            token = restCallLogger.logRESTCall(serverName, userId, "findAssetsInDomain");
            response = new AssetSearchMatchesListResponse();
            AuditLog auditLog = null;
            try {
                AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "findAssetsInDomain");
                ReferenceableHandler<MetadataElementSummary> metadataElementHandler = instanceHandler.getMetadataElementHandler(userId, serverName, "findAssetsInDomain");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssetsInDomain");
                if (requestBody != null) {
                    SearchProperties searchProperties = new SearchProperties();
                    ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
                    PropertyCondition qualNamePropertyCondition = new PropertyCondition();
                    PropertyCondition namePropertyCondition = new PropertyCondition();
                    PropertyCondition displayNamePropertyCondition = new PropertyCondition();
                    PropertyCondition descPropertyCondition = new PropertyCondition();
                    PropertyCondition depImplTypePropertyCondition = new PropertyCondition();
                    PrimitivePropertyValue qualNamePropertyValue = new PrimitivePropertyValue();
                    PrimitivePropertyValue namePropertyValue = new PrimitivePropertyValue();
                    PrimitivePropertyValue displayNamePropertyValue = new PrimitivePropertyValue();
                    PrimitivePropertyValue descPropertyValue = new PrimitivePropertyValue();
                    PrimitivePropertyValue depImplTypePropertyValue = new PrimitivePropertyValue();
                    qualNamePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    qualNamePropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    qualNamePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    qualNamePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    namePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    namePropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    namePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    namePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    displayNamePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    displayNamePropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    displayNamePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    displayNamePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    descPropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    descPropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    descPropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    descPropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    depImplTypePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    depImplTypePropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    depImplTypePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    depImplTypePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    qualNamePropertyCondition.setProperty(OpenMetadataProperty.QUALIFIED_NAME.name);
                    qualNamePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    qualNamePropertyCondition.setValue((InstancePropertyValue)qualNamePropertyValue);
                    propertyConditions.add(qualNamePropertyCondition);
                    namePropertyCondition.setProperty(OpenMetadataProperty.NAME.name);
                    namePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    namePropertyCondition.setValue((InstancePropertyValue)namePropertyValue);
                    propertyConditions.add(namePropertyCondition);
                    displayNamePropertyCondition.setProperty(OpenMetadataProperty.DISPLAY_NAME.name);
                    displayNamePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    displayNamePropertyCondition.setValue((InstancePropertyValue)displayNamePropertyValue);
                    propertyConditions.add(displayNamePropertyCondition);
                    displayNamePropertyCondition.setProperty(OpenMetadataProperty.RESOURCE_NAME.name);
                    displayNamePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    displayNamePropertyCondition.setValue((InstancePropertyValue)displayNamePropertyValue);
                    propertyConditions.add(displayNamePropertyCondition);
                    descPropertyCondition.setProperty(OpenMetadataProperty.DESCRIPTION.name);
                    descPropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    descPropertyCondition.setValue((InstancePropertyValue)descPropertyValue);
                    propertyConditions.add(descPropertyCondition);
                    depImplTypePropertyCondition.setProperty(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name);
                    depImplTypePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    depImplTypePropertyCondition.setValue((InstancePropertyValue)depImplTypePropertyValue);
                    propertyConditions.add(depImplTypePropertyCondition);
                    searchProperties.setMatchCriteria(MatchCriteria.ANY);
                    searchProperties.setConditions(propertyConditions);
                    SearchClassifications searchClassifications = new SearchClassifications();
                    ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
                    ClassificationCondition classificationCondition = new ClassificationCondition();
                    SearchProperties classificationSearchProperties = new SearchProperties();
                    ArrayList<PropertyCondition> classificationPropertyConditions = new ArrayList<PropertyCondition>();
                    PropertyCondition classificationPropertyCondition = new PropertyCondition();
                    PrimitivePropertyValue classificationPropertyValue = new PrimitivePropertyValue();
                    classificationPropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    classificationPropertyValue.setPrimitiveValue((Object)OpenMetadataType.ASSET.typeName);
                    classificationPropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    classificationPropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    classificationPropertyCondition.setProperty(OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name);
                    classificationPropertyCondition.setOperator(PropertyComparisonOperator.EQ);
                    classificationPropertyCondition.setValue((InstancePropertyValue)classificationPropertyValue);
                    classificationPropertyConditions.add(classificationPropertyCondition);
                    classificationSearchProperties.setMatchCriteria(MatchCriteria.ALL);
                    classificationSearchProperties.setConditions(classificationPropertyConditions);
                    classificationCondition.setName(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
                    classificationCondition.setMatchProperties(classificationSearchProperties);
                    classificationConditions.add(classificationCondition);
                    searchClassifications.setMatchCriteria(MatchCriteria.ALL);
                    searchClassifications.setConditions(classificationConditions);
                    List anchoredEntities = metadataElementHandler.findEntities(userId, null, null, searchProperties, null, searchClassifications, null, null, null, false, false, startFrom, pageSize, assetHandler.getSupportedZones(), new Date(), "findAssetsInDomain");
                    if (anchoredEntities == null) break block9;
                    HashMap<String, HashMap<String, EntityDetail>> organizedEntities = new HashMap<String, HashMap<String, EntityDetail>>();
                    for (EntityDetail entityDetail : anchoredEntities) {
                        if (entityDetail == null) continue;
                        OpenMetadataAPIGenericHandler.AnchorIdentifiers anchorIdentifiers = metadataElementHandler.getAnchorGUIDFromAnchorsClassification((EntitySummary)entityDetail, "findAssetsInDomain");
                        String anchorGUID = anchorIdentifiers == null || anchorIdentifiers.anchorGUID == null ? entityDetail.getGUID() : anchorIdentifiers.anchorGUID;
                        HashMap<String, EntityDetail> assetEntityMap = (HashMap<String, EntityDetail>)organizedEntities.get(anchorGUID);
                        if (assetEntityMap == null) {
                            assetEntityMap = new HashMap<String, EntityDetail>();
                        }
                        assetEntityMap.put(entityDetail.getGUID(), entityDetail);
                        organizedEntities.put(anchorGUID, assetEntityMap);
                    }
                    ArrayList<AssetSearchMatches> assetSearchMatchesList = new ArrayList<AssetSearchMatches>();
                    String parameterName = "assetGUID";
                    OpenMetadataAPIGenericConverter converter = metadataElementHandler.getConverter();
                    for (String assetGUID : organizedEntities.keySet()) {
                        AssetElement asset;
                        try {
                            asset = (AssetElement)assetHandler.getBeanFromRepository(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, "findAssetsInDomain");
                        }
                        catch (InvalidParameterException | UserNotAuthorizedException notVisible) {
                            asset = null;
                        }
                        if (asset == null) continue;
                        AssetSearchMatches assetSearchMatches = new AssetSearchMatches(asset);
                        Map assetEntityMap = (Map)organizedEntities.get(assetGUID);
                        ArrayList<MetadataElementSummary> anchoredElements = new ArrayList<MetadataElementSummary>();
                        for (EntityDetail anchoredEntity : assetEntityMap.values()) {
                            MetadataElementSummary metadataElement = (MetadataElementSummary)converter.getNewBean(MetadataElementSummary.class, anchoredEntity, "findAssetsInDomain");
                            anchoredElements.add(metadataElement);
                        }
                        assetSearchMatches.setMatchingElements(anchoredElements);
                        assetSearchMatchesList.add(assetSearchMatches);
                    }
                    response.setSearchMatches(assetSearchMatchesList);
                    break block9;
                }
                this.restExceptionHandler.handleNoRequestBody(userId, "findAssetsInDomain", serverName);
            }
            catch (Exception error) {
                this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findAssetsInDomain", auditLog);
            }
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse findAssets(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String searchStringParameter = "searchString";
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            if (requestBody != null) {
                response.setGUIDs(handler.findAssetGUIDs(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findAssets"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findAssets", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String nameParameterName = "name";
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            if (requestBody != null) {
                response.setGUIDs(handler.getAssetGUIDsByName(userId, OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getAssetsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAssetsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetsResponse getAssetsByMetadataCollectionId(String serverName, String userId, String metadataCollectionId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String nameParameterName = "metadataCollectionId";
        String methodName = "getAssetsByMetadataCollectionId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByMetadataCollectionId");
        AssetsResponse response = new AssetsResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByMetadataCollectionId");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByMetadataCollectionId");
            if (requestBody != null) {
                response.setAssets(handler.getAssetsByMetadataCollectionId(userId, requestBody.getName(), metadataCollectionId, "metadataCollectionId", startFrom, pageSize, false, false, new Date(), "getAssetsByMetadataCollectionId"));
            } else {
                response.setAssets(handler.getAssetsByMetadataCollectionId(userId, null, metadataCollectionId, "metadataCollectionId", startFrom, pageSize, false, false, new Date(), "getAssetsByMetadataCollectionId"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetsByMetadataCollectionId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addRatingToAsset(String serverName, String userId, String guid, RatingRequestBody requestBody) {
        String methodName = "addRatingToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addRatingToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                RatingHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getRatingHandler(userId, serverName, "addRatingToAsset");
                int starRating = StarRating.NOT_RECOMMENDED.getOrdinal();
                if (requestBody.getStarRating() != null) {
                    starRating = requestBody.getStarRating().getOrdinal();
                }
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToAsset");
                handler.saveRating(userId, null, null, guid, "guid", starRating, requestBody.getReview(), requestBody.getIsPublic(), false, false, new Date(), "addRatingToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addRatingToAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addRatingToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeRatingFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRatingFromAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeRatingFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            RatingHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getRatingHandler(userId, serverName, "removeRatingFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromAsset");
            handler.removeRating(userId, null, null, guid, "guid", false, false, new Date(), "removeRatingFromAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeRatingFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLikeToAsset(String serverName, String userId, String guid, FeedbackRequestBody requestBody) {
        String methodName = "addLikeToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLikeToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LikeHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getLikeHandler(userId, serverName, "addLikeToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToAsset");
                handler.saveLike(userId, null, null, guid, "guid", requestBody.getIsPublic(), false, false, new Date(), "addLikeToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLikeToAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addLikeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLikeFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLikeFromAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeLikeFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            LikeHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getLikeHandler(userId, serverName, "removeLikeFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromAsset");
            handler.removeLike(userId, null, null, guid, "guid", false, false, new Date(), "removeLikeFromAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeLikeFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentToAsset(String serverName, String userId, String guid, CommentRequestBody requestBody) {
        String methodName = "addCommentToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOrdinal();
                }
                CommentHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getCommentHandler(userId, serverName, "addCommentToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToAsset");
                response.setGUID(handler.attachNewComment(userId, null, null, guid, guid, "guid", commentType, requestBody.getCommentText(), requestBody.getIsPublic(), null, null, false, false, new Date(), "addCommentToAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentToAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String userId, String assetGUID, String commentGUID, CommentRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "addCommentReply";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentReply");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOrdinal();
                }
                CommentHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getCommentHandler(userId, serverName, "addCommentReply");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentReply");
                response.setGUID(handler.attachNewComment(userId, null, null, assetGUID, commentGUID, "commentGUID", commentType, requestBody.getCommentText(), requestBody.getIsPublic(), null, null, false, false, new Date(), "addCommentReply"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentReply", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String userId, String assetGUID, String commentGUID, CommentRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "updateComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOrdinal();
                }
                CommentHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getCommentHandler(userId, serverName, "updateComment");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
                handler.updateComment(userId, null, null, commentGUID, "commentGUID", null, commentType, requestBody.getCommentText(), requestBody.getIsPublic(), true, null, null, false, false, new Date(), "updateComment");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommentFromAsset(String serverName, String userId, String assetGUID, String commentGUID, NullRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "removeAssetComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAssetComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CommentHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getCommentHandler(userId, serverName, "removeAssetComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAssetComment");
            handler.removeCommentFromElement(userId, null, null, commentGUID, "commentGUID", false, false, new Date(), "removeAssetComment");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeAssetComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MeaningResponse getMeaning(String serverName, String userId, String guid) {
        String guidParameterName = "guid";
        String methodName = "getMeaning";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeaning");
        MeaningResponse response = new MeaningResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaning");
            response.setMeaning((MeaningElement)glossaryTermHandler.getTerm(userId, guid, "guid", false, false, new Date(), "getMeaning"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMeaning", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MeaningsResponse getMeaningByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getMeaningByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeaningByName");
        MeaningsResponse response = new MeaningsResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaningByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaningByName");
            if (requestBody != null) {
                ArrayList<InstanceStatus> limitStatuses = new ArrayList<InstanceStatus>();
                limitStatuses.add(InstanceStatus.ACTIVE);
                response.setElements(glossaryTermHandler.getTermsByName(userId, null, requestBody.getName(), limitStatuses, startFrom, pageSize, false, false, new Date(), "getMeaningByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMeaningByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMeaningByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MeaningsResponse findMeanings(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findMeanings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMeanings");
        MeaningsResponse response = new MeaningsResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "findMeanings");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMeanings");
            if (requestBody != null) {
                ArrayList<InstanceStatus> limitStatuses = new ArrayList<InstanceStatus>();
                limitStatuses.add(InstanceStatus.ACTIVE);
                response.setElements(glossaryTermHandler.findTerms(userId, null, requestBody.getSearchString(), limitStatuses, startFrom, pageSize, false, false, new Date(), "findMeanings"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMeanings", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMeanings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByMeaning(String serverName, String userId, String termGUID, int startFrom, int pageSize) {
        String guidParameterName = "termGUID";
        String methodName = "getAssetsByMeaning";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByMeaning");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByMeaning");
            List attachedEntities = handler.getAttachedEntities(userId, termGUID, "termGUID", "GlossaryTerm", OpenMetadataType.SEMANTIC_ASSIGNMENT.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT.typeName, OpenMetadataType.REFERENCEABLE.typeName, null, null, 1, false, false, startFrom, pageSize, new Date(), "getAssetsByMeaning");
            if (attachedEntities != null) {
                String entityGUIDParameterName = "attachedEntity.getGUID";
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getAssetsByMeaning");
                ArrayList<String> guids = new ArrayList<String>();
                for (EntityDetail entity : attachedEntities) {
                    if (repositoryHelper.isTypeOf(serverName, entity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                        if (guids.contains(entity.getGUID())) continue;
                        guids.add(entity.getGUID());
                        continue;
                    }
                    EntityDetail anchorEntity = handler.validateAnchorEntity(userId, entity.getGUID(), OpenMetadataType.REFERENCEABLE.typeName, entity, "attachedEntity.getGUID", false, false, false, false, handler.getSupportedZones(), new Date(), "getAssetsByMeaning");
                    if (anchorEntity == null || guids.contains(anchorEntity.getGUID())) continue;
                    guids.add(anchorEntity.getGUID());
                }
                response.setGUIDs(guids);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetsByMeaning", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLogMessageToAsset(String serverName, String userId, String guid, LogRecordRequestBody requestBody) {
        String methodName = "addLogMessageToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLogMessageToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LoggingHandler loggingHandler = instanceHandler.getLoggingHandler(userId, serverName, "addLogMessageToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLogMessageToAsset");
                loggingHandler.addLogMessageToAsset(userId, guid, requestBody.getConnectorInstanceId(), requestBody.getConnectionName(), requestBody.getConnectorType(), requestBody.getContextId(), requestBody.getMessage());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLogMessageToAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addLogMessageToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createTag(String serverName, String userId, InformalTagProperties requestBody) {
        String methodName = "createTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTag");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createTag(userId, null, null, requestBody.getName(), requestBody.getDescription(), !requestBody.getIsPrivateTag(), null, null, new Date(), "createTag"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String userId, String tagGUID, TagUpdateRequestBody requestBody) {
        String methodName = "updateTagDescription";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTagDescription");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, null, null, tagGUID, "tagGUID", requestBody.getDescription(), null, null, false, false, new Date(), "updateTagDescription");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateTagDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String userId, String tagGUID, NullRequestBody requestBody) {
        String methodName = "deleteTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            handler.deleteTag(userId, null, null, tagGUID, "tagGUID", false, false, new Date(), "deleteTag");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagResponse getTag(String serverName, String userId, String guid) {
        String methodName = "getTag";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTag");
        InformalTagResponse response = new InformalTagResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            response.setElement((InformalTagElement)handler.getTag(userId, guid, "guid", false, false, new Date(), "getTag"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getTagsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            if (requestBody != null) {
                response.setElements(handler.getTagsByName(userId, requestBody.getName(), "tagName", startFrom, pageSize, false, false, new Date(), "getTagsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getTagsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getMyTagsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getMyTagsByName";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMyTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            if (requestBody != null) {
                response.setElements(handler.getMyTagsByName(userId, requestBody.getName(), "tagName", startFrom, pageSize, false, false, new Date(), "getMyTagsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMyTagsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMyTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findTags(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findTags";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            if (requestBody != null) {
                response.setElements(handler.findTags(userId, requestBody.getSearchString(), "tagName", startFrom, pageSize, false, false, new Date(), "findTags"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findTags", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findMyTags(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findMyTags";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMyTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            if (requestBody != null) {
                response.setElements(handler.findMyTags(userId, requestBody.getSearchString(), "tagName", startFrom, pageSize, false, false, new Date(), "findMyTags"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMyTags", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToAsset(String serverName, String userId, String assetGUID, String tagGUID, FeedbackRequestBody requestBody) {
        String methodName = "addTagToAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToAsset");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "addTagToAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToAsset");
            handler.addTagToElement(userId, null, null, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "addTagToAsset"), isPublic, null, null, false, false, new Date(), "addTagToAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addTagToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToElement(String serverName, String userId, String elementGUID, String tagGUID, FeedbackRequestBody requestBody) {
        String methodName = "addTagToElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToElement");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "addTagToElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToElement");
            handler.addTagToElement(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, tagGUID, "tagGUID", isPublic, null, null, false, false, new Date(), "addTagToElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addTagToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromAsset(String serverName, String userId, String assetGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "removeTagFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromAsset");
            handler.removeTagFromElement(userId, null, null, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "removeTagFromAsset"), false, false, new Date(), "removeTagFromAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeTagFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromElement(String serverName, String userId, String elementGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "removeTagFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromElement");
            handler.removeTagFromElement(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "removeTagFromElement"), false, false, new Date(), "removeTagFromElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeTagFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByTag(String serverName, String userId, String tagGUID, int startFrom, int pageSize) {
        String methodName = "getAssetsByTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByTag");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByTag");
            response.setGUIDs(handler.getAssetGUIDsByTag(userId, tagGUID, "tagGUID", startFrom, pageSize, false, false, new Date(), "getAssetsByTag"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetsByTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

