/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetconsumer.handlers.LoggingHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerInstanceHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetGraphResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetLineageGraphRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetLineageGraphResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetSearchMatchesListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CommentRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FeedbackRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformalTagResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformalTagsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LogRecordRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.MeaningResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MeaningsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RatingRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.TagUpdateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CommentHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.generichandlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LikeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIAnchorHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.RatingHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.mermaid.AssetGraphMermaidGraphBuilder;
import org.odpi.openmetadata.commonservices.mermaid.AssetLineageGraphMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetLineageGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetLineageGraphNode;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetLineageGraphRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetSearchMatches;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformalTagElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MeaningElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.InformalTagProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class AssetConsumerRESTServices {
    private static final AssetConsumerInstanceHandler instanceHandler = new AssetConsumerInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetConsumerRESTServices.class), instanceHandler.getServiceName());

    public RegisteredOMAGServiceResponse getServiceDescription(String serverName, String userId) {
        String methodName = "getServiceDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServiceDescription");
        RegisteredOMAGServiceResponse response = new RegisteredOMAGServiceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServiceDescription");
            response.setService(instanceHandler.getRegisteredOMAGService(userId, serverName, AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceCode(), "getServiceDescription"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServiceDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OCFConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        OCFConnectionResponse response = new OCFConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getAssetForConnectionName(String serverName, String userId, String connectionName) {
        String connectionNameParameterName = "connectionName";
        String methodName = "getAssetForConnectionName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetForConnectionName");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetForConnectionName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetForConnectionName");
            response.setGUID(handler.getAssetForConnectionName(userId, connectionName, "connectionName", false, false, handler.getSupportedZones(), new Date(), "getAssetForConnectionName"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetForConnectionName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetGraphResponse getAssetGraph(String serverName, String userId, String assetGUID, int startFrom, int pageSize) {
        String parameterName = "assetGUID";
        String methodName = "getAssetGraph";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetGraph");
        AssetGraphResponse response = new AssetGraphResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getAssetGraph");
            ReferenceableHandler<MetadataElementSummary> metadataElementHandler = instanceHandler.getMetadataElementHandler(userId, serverName, "getAssetGraph");
            ReferenceableHandler<MetadataRelationship> metadataRelationshipHandler = instanceHandler.getMetadataRelationshipHandler(userId, serverName, "getAssetGraph");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetGraph");
            AssetElement asset = (AssetElement)assetHandler.getBeanFromRepository(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, "getAssetGraph");
            if (asset != null) {
                AssetGraph assetGraph = new AssetGraph(asset);
                HashMap<String, Relationship> receivedRelationships = new HashMap<String, Relationship>();
                ArrayList<String> iscQualifiedNames = new ArrayList<String>();
                List relationships = metadataRelationshipHandler.getAllAttachmentLinks(userId, asset.getElementHeader().getGUID(), "assetGUID", OpenMetadataType.ASSET.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, new Date(), "getAssetGraph");
                if (relationships != null) {
                    for (Relationship relationship : relationships) {
                        String iscQualifiedName;
                        if (relationship == null) continue;
                        if (!assetHandler.getRepositoryHelper().isTypeOf(instanceHandler.getServiceName(), relationship.getType().getTypeDefName(), OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName) && !assetHandler.getRepositoryHelper().isTypeOf(instanceHandler.getServiceName(), relationship.getType().getTypeDefName(), OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName)) {
                            receivedRelationships.put(relationship.getGUID(), relationship);
                        }
                        if ((iscQualifiedName = assetHandler.getRepositoryHelper().getStringProperty(assetHandler.getServiceName(), OpenMetadataProperty.ISC_QUALIFIED_NAME.name, relationship.getProperties(), "getAssetGraph")) == null || iscQualifiedNames.contains(iscQualifiedName)) continue;
                        iscQualifiedNames.add(iscQualifiedName);
                    }
                }
                SearchClassifications searchClassifications = new SearchClassifications();
                ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
                ClassificationCondition classificationCondition = new ClassificationCondition();
                SearchProperties searchProperties = new SearchProperties();
                ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
                PropertyCondition propertyCondition = new PropertyCondition();
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue((Object)asset.getElementHeader().getGUID());
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                propertyCondition.setProperty(OpenMetadataProperty.ANCHOR_GUID.name);
                propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                propertyCondition.setValue((InstancePropertyValue)primitivePropertyValue);
                propertyConditions.add(propertyCondition);
                searchProperties.setMatchCriteria(MatchCriteria.ALL);
                searchProperties.setConditions(propertyConditions);
                classificationCondition.setName(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
                classificationCondition.setMatchProperties(searchProperties);
                classificationConditions.add(classificationCondition);
                searchClassifications.setMatchCriteria(MatchCriteria.ALL);
                searchClassifications.setConditions(classificationConditions);
                List anchoredElements = metadataElementHandler.findBeans(userId, null, null, null, null, searchClassifications, null, null, SequencingOrder.CREATION_DATE_RECENT, true, false, startFrom, pageSize, assetHandler.getSupportedZones(), new Date(), "getAssetGraph");
                assetGraph.setAnchoredElements(anchoredElements);
                if (anchoredElements != null) {
                    String anchoredElementParameterName = "anchoredElement.getGUID";
                    for (MetadataElementSummary metadataElement : anchoredElements) {
                        if (metadataElement == null || (relationships = metadataRelationshipHandler.getAllAttachmentLinks(userId, metadataElement.getElementHeader().getGUID(), "anchoredElement.getGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, false, new Date(), "getAssetGraph")) == null) continue;
                        for (Relationship relationship : relationships) {
                            String iscQualifiedName;
                            if (relationship == null) continue;
                            if (!assetHandler.getRepositoryHelper().isTypeOf(instanceHandler.getServiceName(), relationship.getType().getTypeDefName(), OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName) && !assetHandler.getRepositoryHelper().isTypeOf(instanceHandler.getServiceName(), relationship.getType().getTypeDefName(), OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName)) {
                                receivedRelationships.put(relationship.getGUID(), relationship);
                            }
                            if ((iscQualifiedName = assetHandler.getRepositoryHelper().getStringProperty(assetHandler.getServiceName(), OpenMetadataProperty.ISC_QUALIFIED_NAME.name, relationship.getProperties(), "getAssetGraph")) == null || iscQualifiedNames.contains(iscQualifiedName)) continue;
                            iscQualifiedNames.add(iscQualifiedName);
                        }
                    }
                }
                if (!receivedRelationships.isEmpty()) {
                    OpenMetadataAPIGenericConverter converter = metadataRelationshipHandler.getConverter();
                    ArrayList<MetadataRelationship> metadataRelationships = new ArrayList<MetadataRelationship>();
                    for (Relationship relationship : receivedRelationships.values()) {
                        if (relationship == null) continue;
                        MetadataRelationship metadataRelationship = (MetadataRelationship)converter.getNewRelationshipBean(MetadataRelationship.class, relationship, "getAssetGraph");
                        metadataRelationships.add(metadataRelationship);
                    }
                    assetGraph.setRelationships(metadataRelationships);
                }
                ArrayList<MetadataElementSummary> informationSupplyChains = new ArrayList<MetadataElementSummary>();
                if (!iscQualifiedNames.isEmpty()) {
                    String iscQualifiedNameParameterName = "iscParameterName";
                    for (String iscQualifiedName : iscQualifiedNames) {
                        MetadataElementSummary informationSupplyChain = (MetadataElementSummary)metadataElementHandler.getBeanByUniqueName(userId, iscQualifiedName, "iscParameterName", OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeGUID, OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, false, new Date(), "getAssetGraph");
                        if (informationSupplyChain == null) continue;
                        informationSupplyChains.add(informationSupplyChain);
                    }
                }
                if (!informationSupplyChains.isEmpty()) {
                    assetGraph.setInformationSupplyChains(informationSupplyChains);
                }
                AssetGraphMermaidGraphBuilder graphBuilder = new AssetGraphMermaidGraphBuilder(assetGraph);
                assetGraph.setMermaidGraph(graphBuilder.getMermaidGraph());
                assetGraph.setInformationSupplyChainMermaidGraph(graphBuilder.getInformationSupplyChainMermaidGraph());
                assetGraph.setFieldLevelLineageGraph(graphBuilder.getFieldLevelLineageGraph());
                response.setAssetGraph(assetGraph);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetLineageGraphResponse getAssetLineageGraph(String serverName, String userId, String assetGUID, AssetLineageGraphRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getAssetLineageGraph";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetLineageGraph");
        AssetLineageGraphResponse response = new AssetLineageGraphResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getAssetLineageGraph");
            ReferenceableHandler<MetadataRelationship> metadataRelationshipHandler = instanceHandler.getMetadataRelationshipHandler(userId, serverName, "getAssetLineageGraph");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetLineageGraph");
            ArrayList<AssetLineageGraphNode> linkedAssets = new ArrayList<AssetLineageGraphNode>();
            ArrayList<AssetLineageGraphRelationship> lineageRelationships = new ArrayList<AssetLineageGraphRelationship>();
            HashSet<String> upstreamProcessedAssets = new HashSet<String>();
            HashSet<String> downstreamProcessedAssets = new HashSet<String>();
            List<String> lineageRelationshipTypeNames = null;
            String limitToInformationSupplyChain = null;
            String highlightInformationSupplyChain = null;
            Date asOfTime = null;
            Date effectiveTime = new Date();
            if (requestBody != null) {
                lineageRelationshipTypeNames = this.getLineageRelationshipTypeNames(requestBody.getRelationshipTypes());
                limitToInformationSupplyChain = requestBody.getLimitToISCQualifiedName();
                highlightInformationSupplyChain = requestBody.getHighlightISCQualifiedName();
                asOfTime = requestBody.getAsOfTime();
                effectiveTime = requestBody.getEffectiveTime();
            }
            this.getAssetLineageGraphNodes(userId, assetGUID, 0, lineageRelationshipTypeNames, limitToInformationSupplyChain, asOfTime, effectiveTime, startFrom, pageSize, linkedAssets, lineageRelationships, upstreamProcessedAssets, downstreamProcessedAssets, assetHandler, (OpenMetadataAPIGenericConverter<MetadataRelationship>)metadataRelationshipHandler.getConverter());
            if (!linkedAssets.isEmpty()) {
                AssetLineageGraph assetLineageGraph = new AssetLineageGraph((AssetLineageGraphNode)linkedAssets.get(0));
                if (linkedAssets.size() > 1) {
                    assetLineageGraph.setLinkedAssets(new ArrayList(linkedAssets.subList(1, linkedAssets.size())));
                }
                assetLineageGraph.setLineageRelationships(this.deDupLineageRelationships(lineageRelationships));
                AssetLineageGraphMermaidGraphBuilder graphBuilder = new AssetLineageGraphMermaidGraphBuilder(assetLineageGraph, highlightInformationSupplyChain);
                assetLineageGraph.setMermaidGraph(graphBuilder.getMermaidGraph());
                assetLineageGraph.setEdgeMermaidGraph(graphBuilder.getEdgeMermaidGraph());
                response.setAssetLineageGraph(assetLineageGraph);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetLineageGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<AssetLineageGraphRelationship> deDupLineageRelationships(List<AssetLineageGraphRelationship> lineageRelationships) {
        HashMap<CallSite, AssetLineageGraphRelationship> relationshipMap = new HashMap<CallSite, AssetLineageGraphRelationship>();
        for (AssetLineageGraphRelationship lineageRelationship : lineageRelationships) {
            relationshipMap.put((CallSite)((Object)(lineageRelationship.getEnd1AssetGUID() + lineageRelationship.getEnd2AssetGUID())), lineageRelationship);
        }
        return new ArrayList<AssetLineageGraphRelationship>(relationshipMap.values());
    }

    private List<String> getLineageRelationshipTypeNames(List<String> relationshipTypes) {
        List<String> lineageRelationshipTypeNames = relationshipTypes;
        if (lineageRelationshipTypeNames == null || lineageRelationshipTypeNames.isEmpty()) {
            lineageRelationshipTypeNames = new ArrayList<String>();
            lineageRelationshipTypeNames.add(OpenMetadataType.DATA_FLOW_RELATIONSHIP.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.CONTROL_FLOW_RELATIONSHIP.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.LINEAGE_MAPPING_RELATIONSHIP.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.PROCESS_CALL_RELATIONSHIP.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.DATA_MAPPING_RELATIONSHIP.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.REQUEST_FOR_ACTION_TARGET.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.ACTION_ASSIGNMENT_RELATIONSHIP.typeName);
            lineageRelationshipTypeNames.add(OpenMetadataType.TO_DO_SOURCE_RELATIONSHIP.typeName);
        }
        return lineageRelationshipTypeNames;
    }

    void getAssetLineageGraphNodes(String userId, String elementGUID, int direction, List<String> lineageRelationshipTypeNames, String limitToInformationSupplyChain, Date asOfTime, Date effectiveTime, int startFrom, int pageSize, List<AssetLineageGraphNode> linkedAssets, List<AssetLineageGraphRelationship> lineageRelationships, Set<String> upstreamProcessedAssets, Set<String> downstreamProcessedAssets, AssetHandler<AssetElement> assetHandler, OpenMetadataAPIGenericConverter<MetadataRelationship> converter) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        HashMap<String, LineageLink> upstreamAssets = new HashMap<String, LineageLink>();
        HashMap<String, LineageLink> downstreamAssets = new HashMap<String, LineageLink>();
        AssetLineageGraphNode asset = this.getAssetLineageGraphNode(userId, elementGUID, direction, lineageRelationshipTypeNames, limitToInformationSupplyChain, asOfTime, effectiveTime, startFrom, pageSize, upstreamAssets, downstreamAssets, assetHandler, converter);
        if (asset != null) {
            LineageLink lineageLink;
            AssetLineageGraphRelationship assetLineageGraphRelationship;
            if (direction == 0 || direction == 1) {
                downstreamProcessedAssets.add(asset.getElementHeader().getGUID());
            }
            if (direction == 0 || direction == 2) {
                upstreamProcessedAssets.add(asset.getElementHeader().getGUID());
            }
            linkedAssets.add(asset);
            for (String linkedAssetGUID : upstreamAssets.keySet()) {
                assetLineageGraphRelationship = new AssetLineageGraphRelationship();
                lineageLink = (LineageLink)upstreamAssets.get(linkedAssetGUID);
                if (lineageLink != null) {
                    if (lineageLink.relationshipTypes != null) {
                        assetLineageGraphRelationship.setRelationshipTypes(new ArrayList<String>(lineageLink.relationshipTypes));
                    }
                    if (lineageLink.informationSupplyChains != null) {
                        assetLineageGraphRelationship.setInformationSupplyChains(new ArrayList<String>(lineageLink.informationSupplyChains));
                    }
                }
                assetLineageGraphRelationship.setEnd1AssetGUID(linkedAssetGUID);
                assetLineageGraphRelationship.setEnd2AssetGUID(asset.getElementHeader().getGUID());
                lineageRelationships.add(assetLineageGraphRelationship);
                if (upstreamProcessedAssets.contains(linkedAssetGUID)) continue;
                this.getAssetLineageGraphNodes(userId, linkedAssetGUID, 2, lineageRelationshipTypeNames, limitToInformationSupplyChain, asOfTime, effectiveTime, startFrom, pageSize, linkedAssets, lineageRelationships, upstreamProcessedAssets, downstreamProcessedAssets, assetHandler, converter);
            }
            for (String linkedAssetGUID : downstreamAssets.keySet()) {
                assetLineageGraphRelationship = new AssetLineageGraphRelationship();
                lineageLink = (LineageLink)downstreamAssets.get(linkedAssetGUID);
                if (lineageLink != null) {
                    if (lineageLink.relationshipTypes != null) {
                        assetLineageGraphRelationship.setRelationshipTypes(new ArrayList<String>(lineageLink.relationshipTypes));
                    }
                    if (lineageLink.informationSupplyChains != null) {
                        assetLineageGraphRelationship.setInformationSupplyChains(new ArrayList<String>(lineageLink.informationSupplyChains));
                    }
                }
                assetLineageGraphRelationship.setEnd1AssetGUID(asset.getElementHeader().getGUID());
                assetLineageGraphRelationship.setEnd2AssetGUID(linkedAssetGUID);
                lineageRelationships.add(assetLineageGraphRelationship);
                if (downstreamProcessedAssets.contains(linkedAssetGUID)) continue;
                this.getAssetLineageGraphNodes(userId, linkedAssetGUID, 1, lineageRelationshipTypeNames, limitToInformationSupplyChain, asOfTime, effectiveTime, startFrom, pageSize, linkedAssets, lineageRelationships, upstreamProcessedAssets, downstreamProcessedAssets, assetHandler, converter);
            }
        }
    }

    AssetLineageGraphNode getAssetLineageGraphNode(String userId, String assetGUID, int direction, List<String> lineageRelationshipTypeNames, String limitToInformationSupplyChain, Date asOfTime, Date effectiveTime, int startFrom, int pageSize, Map<String, LineageLink> upstreamAssets, Map<String, LineageLink> downstreamAssets, AssetHandler<AssetElement> assetHandler, OpenMetadataAPIGenericConverter<MetadataRelationship> converter) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "getAssetLineageGraphNode";
        AssetElement asset = (AssetElement)assetHandler.getBeanFromRepository(userId, assetGUID, "assetGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, true, false, effectiveTime, "getAssetLineageGraphNode");
        if (asset != null) {
            AssetLineageGraphNode assetLineageGraphNode = new AssetLineageGraphNode(asset);
            List<Relationship> relationships = this.getAssetLineageRelationships(userId, asset.getElementHeader().getGUID(), direction, lineageRelationshipTypeNames, limitToInformationSupplyChain, asOfTime, effectiveTime, startFrom, pageSize, assetHandler);
            ArrayList<Relationship> upstreamRelationships = new ArrayList<Relationship>();
            ArrayList<Relationship> downstreamRelationships = new ArrayList<Relationship>();
            ArrayList<Relationship> internalRelationship = new ArrayList<Relationship>();
            for (Relationship relationship : relationships) {
                String relationshipSupplyChain;
                Set<String> currentInformationSupplyChains;
                Set<String> currentRelationshipNames;
                LineageLink currentLineageLinks;
                if (relationship == null) continue;
                String relationshipName = this.getRelationshipName(relationship, assetHandler.getRepositoryHelper());
                if (!lineageRelationshipTypeNames.contains(relationship.getType().getTypeDefName())) continue;
                String end1AnchorGUID = this.getAnchorGUID(relationship.getEntityOneProxy(), assetHandler);
                String end2AnchorGUID = this.getAnchorGUID(relationship.getEntityTwoProxy(), assetHandler);
                if (assetGUID.equals(end1AnchorGUID)) {
                    if (assetGUID.equals(end2AnchorGUID)) {
                        internalRelationship.add(relationship);
                        continue;
                    }
                    currentLineageLinks = downstreamAssets.get(relationship.getEntityTwoProxy().getGUID());
                    if (currentLineageLinks == null) {
                        currentLineageLinks = new LineageLink(null, null);
                    }
                    if ((currentRelationshipNames = currentLineageLinks.relationshipTypes) == null) {
                        currentRelationshipNames = new HashSet<String>();
                    }
                    currentRelationshipNames.add(relationshipName);
                    currentInformationSupplyChains = currentLineageLinks.informationSupplyChains;
                    relationshipSupplyChain = assetHandler.getRepositoryHelper().getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.ISC_QUALIFIED_NAME.name, relationship.getProperties(), "getAssetLineageGraphNode");
                    if (relationshipSupplyChain != null) {
                        if (currentInformationSupplyChains == null) {
                            currentInformationSupplyChains = new HashSet<String>();
                        }
                        currentInformationSupplyChains.add(relationshipSupplyChain);
                    }
                    downstreamAssets.put(end2AnchorGUID, new LineageLink(currentRelationshipNames, currentInformationSupplyChains));
                    downstreamRelationships.add(relationship);
                    continue;
                }
                if (!assetGUID.equals(end2AnchorGUID)) continue;
                currentLineageLinks = upstreamAssets.get(relationship.getEntityTwoProxy().getGUID());
                if (currentLineageLinks == null) {
                    currentLineageLinks = new LineageLink(null, null);
                }
                if ((currentRelationshipNames = currentLineageLinks.relationshipTypes) == null) {
                    currentRelationshipNames = new HashSet<String>();
                }
                currentInformationSupplyChains = currentLineageLinks.informationSupplyChains;
                relationshipSupplyChain = assetHandler.getRepositoryHelper().getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.ISC_QUALIFIED_NAME.name, relationship.getProperties(), "getAssetLineageGraphNode");
                if (relationshipSupplyChain != null) {
                    if (currentInformationSupplyChains == null) {
                        currentInformationSupplyChains = new HashSet<String>();
                    }
                    currentInformationSupplyChains.add(relationshipSupplyChain);
                }
                currentRelationshipNames.add(relationshipName);
                upstreamAssets.put(end1AnchorGUID, new LineageLink(currentRelationshipNames, currentInformationSupplyChains));
                upstreamRelationships.add(relationship);
            }
            assetLineageGraphNode.setUpstreamRelationships(this.convertRelationships(upstreamRelationships, converter));
            assetLineageGraphNode.setDownstreamRelationships(this.convertRelationships(downstreamRelationships, converter));
            assetLineageGraphNode.setInternalRelationships(this.convertRelationships(internalRelationship, converter));
            return assetLineageGraphNode;
        }
        return null;
    }

    private String getRelationshipName(Relationship relationship, OMRSRepositoryHelper repositoryHelper) {
        String methodName = "getRelationshipName";
        Object relationshipName = relationship.getType().getTypeDefName();
        String label = repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.LABEL.name, relationship.getProperties(), "getRelationshipName");
        if (label != null) {
            relationshipName = label + " [" + (String)relationshipName + "]";
        }
        return relationshipName;
    }

    private String getAnchorGUID(EntityProxy entityProxy, AssetHandler<AssetElement> assetHandler) {
        String methodName = "getAnchorGUID";
        if (entityProxy != null) {
            if (assetHandler.getRepositoryHelper().isTypeOf("getAnchorGUID", entityProxy.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                return entityProxy.getGUID();
            }
            List classifications = entityProxy.getClassifications();
            if (classifications != null) {
                for (Classification classification : classifications) {
                    if (classification == null || !OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(classification.getName())) continue;
                    String anchorGUID = assetHandler.getRepositoryHelper().removeStringProperty(entityProxy.getGUID(), OpenMetadataProperty.ANCHOR_GUID.name, classification.getProperties(), "getAnchorGUID");
                    if (anchorGUID == null) {
                        anchorGUID = entityProxy.getGUID();
                    }
                    return anchorGUID;
                }
            }
            return entityProxy.getGUID();
        }
        return null;
    }

    private List<MetadataRelationship> convertRelationships(List<Relationship> relationships, OpenMetadataAPIGenericConverter<MetadataRelationship> converter) throws PropertyServerException {
        String methodName = "convertRelationships";
        if (!relationships.isEmpty()) {
            ArrayList<MetadataRelationship> results = new ArrayList<MetadataRelationship>();
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                MetadataRelationship metadataRelationship = (MetadataRelationship)converter.getNewRelationshipBean(MetadataRelationship.class, relationship, "convertRelationships");
                results.add(metadataRelationship);
            }
            return results;
        }
        return null;
    }

    private List<Relationship> getAssetLineageRelationships(String userId, String assetGUID, int direction, List<String> lineageRelationshipTypeNames, String limitToInformationSupplyChain, Date asOfTime, Date effectiveTime, int startFrom, int pageSize, AssetHandler<AssetElement> assetHandler) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "getAssetLineageRelationships";
        ArrayList<Relationship> lineageRelationships = new ArrayList<Relationship>(this.getLineageRelationshipsForElement(userId, assetGUID, "assetGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, direction, lineageRelationshipTypeNames, limitToInformationSupplyChain, asOfTime, effectiveTime, assetHandler));
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
        PropertyCondition propertyCondition = new PropertyCondition();
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)assetGUID);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
        propertyCondition.setProperty(OpenMetadataProperty.ANCHOR_GUID.name);
        propertyCondition.setOperator(PropertyComparisonOperator.EQ);
        propertyCondition.setValue((InstancePropertyValue)primitivePropertyValue);
        propertyConditions.add(propertyCondition);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        searchProperties.setConditions(propertyConditions);
        classificationCondition.setName(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
        classificationCondition.setMatchProperties(searchProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        searchClassifications.setConditions(classificationConditions);
        List anchoredElements = assetHandler.findEntities(userId, OpenMetadataType.SCHEMA_ELEMENT.typeName, null, null, null, searchClassifications, asOfTime, null, null, true, false, startFrom, pageSize, assetHandler.getSupportedZones(), effectiveTime, "getAssetLineageRelationships");
        if (anchoredElements != null) {
            String anchoredElementGUIDParameterName = "anchoredElement.getGUID()";
            for (EntityDetail anchoredElement : anchoredElements) {
                lineageRelationships.addAll(this.getLineageRelationshipsForElement(userId, anchoredElement.getGUID(), "anchoredElement.getGUID()", OpenMetadataType.SCHEMA_ELEMENT.typeName, direction, lineageRelationshipTypeNames, limitToInformationSupplyChain, asOfTime, effectiveTime, assetHandler));
            }
        }
        return lineageRelationships;
    }

    List<Relationship> getLineageRelationshipsForElement(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int direction, List<String> lineageRelationshipTypeNames, String limitToInformationSupplyChain, Date asOfTime, Date effectiveTime, AssetHandler<AssetElement> assetHandler) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getLineageRelationshipsForElement";
        ArrayList<Relationship> lineageRelationships = new ArrayList<Relationship>();
        List relationships = assetHandler.getAllAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, null, asOfTime, SequencingOrder.CREATION_DATE_RECENT, null, true, false, effectiveTime, "getLineageRelationshipsForElement");
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || !lineageRelationshipTypeNames.contains(relationship.getType().getTypeDefName()) || direction != 0 && (direction != 1 || !elementGUID.equals(relationship.getEntityOneProxy().getGUID())) && (direction != 2 || !elementGUID.equals(relationship.getEntityTwoProxy().getGUID()))) continue;
                if (limitToInformationSupplyChain != null) {
                    String relationshipSupplyChain = assetHandler.getRepositoryHelper().getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.ISC_QUALIFIED_NAME.name, relationship.getProperties(), "getLineageRelationshipsForElement");
                    if (!limitToInformationSupplyChain.equals(relationshipSupplyChain)) continue;
                    lineageRelationships.add(relationship);
                    continue;
                }
                lineageRelationships.add(relationship);
            }
        }
        return lineageRelationships;
    }

    public AssetSearchMatchesListResponse findAssetsInDomain(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        AssetSearchMatchesListResponse response;
        RESTCallToken token;
        block9: {
            String methodName = "findAssetsInDomain";
            token = restCallLogger.logRESTCall(serverName, userId, "findAssetsInDomain");
            response = new AssetSearchMatchesListResponse();
            AuditLog auditLog = null;
            try {
                AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "findAssetsInDomain");
                ReferenceableHandler<MetadataElementSummary> metadataElementHandler = instanceHandler.getMetadataElementHandler(userId, serverName, "findAssetsInDomain");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssetsInDomain");
                if (requestBody != null) {
                    SearchProperties searchProperties = new SearchProperties();
                    ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
                    PropertyCondition qualNamePropertyCondition = new PropertyCondition();
                    PropertyCondition namePropertyCondition = new PropertyCondition();
                    PropertyCondition displayNamePropertyCondition = new PropertyCondition();
                    PropertyCondition descPropertyCondition = new PropertyCondition();
                    PropertyCondition depImplTypePropertyCondition = new PropertyCondition();
                    PrimitivePropertyValue qualNamePropertyValue = new PrimitivePropertyValue();
                    PrimitivePropertyValue namePropertyValue = new PrimitivePropertyValue();
                    PrimitivePropertyValue displayNamePropertyValue = new PrimitivePropertyValue();
                    PrimitivePropertyValue descPropertyValue = new PrimitivePropertyValue();
                    PrimitivePropertyValue depImplTypePropertyValue = new PrimitivePropertyValue();
                    qualNamePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    qualNamePropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    qualNamePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    qualNamePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    namePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    namePropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    namePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    namePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    displayNamePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    displayNamePropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    displayNamePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    displayNamePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    descPropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    descPropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    descPropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    descPropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    depImplTypePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    depImplTypePropertyValue.setPrimitiveValue((Object)requestBody.getSearchString());
                    depImplTypePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    depImplTypePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    qualNamePropertyCondition.setProperty(OpenMetadataProperty.QUALIFIED_NAME.name);
                    qualNamePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    qualNamePropertyCondition.setValue((InstancePropertyValue)qualNamePropertyValue);
                    propertyConditions.add(qualNamePropertyCondition);
                    namePropertyCondition.setProperty(OpenMetadataProperty.NAME.name);
                    namePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    namePropertyCondition.setValue((InstancePropertyValue)namePropertyValue);
                    propertyConditions.add(namePropertyCondition);
                    displayNamePropertyCondition.setProperty(OpenMetadataProperty.DISPLAY_NAME.name);
                    displayNamePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    displayNamePropertyCondition.setValue((InstancePropertyValue)displayNamePropertyValue);
                    propertyConditions.add(displayNamePropertyCondition);
                    displayNamePropertyCondition.setProperty(OpenMetadataProperty.RESOURCE_NAME.name);
                    displayNamePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    displayNamePropertyCondition.setValue((InstancePropertyValue)displayNamePropertyValue);
                    propertyConditions.add(displayNamePropertyCondition);
                    descPropertyCondition.setProperty(OpenMetadataProperty.DESCRIPTION.name);
                    descPropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    descPropertyCondition.setValue((InstancePropertyValue)descPropertyValue);
                    propertyConditions.add(descPropertyCondition);
                    depImplTypePropertyCondition.setProperty(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name);
                    depImplTypePropertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                    depImplTypePropertyCondition.setValue((InstancePropertyValue)depImplTypePropertyValue);
                    propertyConditions.add(depImplTypePropertyCondition);
                    searchProperties.setMatchCriteria(MatchCriteria.ANY);
                    searchProperties.setConditions(propertyConditions);
                    SearchClassifications searchClassifications = new SearchClassifications();
                    ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
                    ClassificationCondition classificationCondition = new ClassificationCondition();
                    SearchProperties classificationSearchProperties = new SearchProperties();
                    ArrayList<PropertyCondition> classificationPropertyConditions = new ArrayList<PropertyCondition>();
                    PropertyCondition classificationPropertyCondition = new PropertyCondition();
                    PrimitivePropertyValue classificationPropertyValue = new PrimitivePropertyValue();
                    classificationPropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    classificationPropertyValue.setPrimitiveValue((Object)OpenMetadataType.ASSET.typeName);
                    classificationPropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    classificationPropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    classificationPropertyCondition.setProperty(OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name);
                    classificationPropertyCondition.setOperator(PropertyComparisonOperator.EQ);
                    classificationPropertyCondition.setValue((InstancePropertyValue)classificationPropertyValue);
                    classificationPropertyConditions.add(classificationPropertyCondition);
                    classificationSearchProperties.setMatchCriteria(MatchCriteria.ALL);
                    classificationSearchProperties.setConditions(classificationPropertyConditions);
                    classificationCondition.setName(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
                    classificationCondition.setMatchProperties(classificationSearchProperties);
                    classificationConditions.add(classificationCondition);
                    searchClassifications.setMatchCriteria(MatchCriteria.ALL);
                    searchClassifications.setConditions(classificationConditions);
                    List anchoredEntities = metadataElementHandler.findEntities(userId, null, null, searchProperties, null, searchClassifications, requestBody.getAsOfTime(), null, null, false, false, startFrom, pageSize, assetHandler.getSupportedZones(), requestBody.getEffectiveTime(), "findAssetsInDomain");
                    if (anchoredEntities == null) break block9;
                    HashMap<String, HashMap<String, EntityDetail>> organizedEntities = new HashMap<String, HashMap<String, EntityDetail>>();
                    for (EntityDetail entityDetail : anchoredEntities) {
                        if (entityDetail == null) continue;
                        OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = metadataElementHandler.getAnchorsFromAnchorsClassification((EntitySummary)entityDetail, "findAssetsInDomain");
                        String anchorGUID = anchorIdentifiers == null || anchorIdentifiers.anchorGUID == null ? entityDetail.getGUID() : anchorIdentifiers.anchorGUID;
                        HashMap<String, EntityDetail> assetEntityMap = (HashMap<String, EntityDetail>)organizedEntities.get(anchorGUID);
                        if (assetEntityMap == null) {
                            assetEntityMap = new HashMap<String, EntityDetail>();
                        }
                        assetEntityMap.put(entityDetail.getGUID(), entityDetail);
                        organizedEntities.put(anchorGUID, assetEntityMap);
                    }
                    ArrayList<AssetSearchMatches> assetSearchMatchesList = new ArrayList<AssetSearchMatches>();
                    String parameterName = "assetGUID";
                    OpenMetadataAPIGenericConverter converter = metadataElementHandler.getConverter();
                    for (String assetGUID : organizedEntities.keySet()) {
                        AssetElement asset;
                        try {
                            asset = (AssetElement)assetHandler.getBeanFromRepository(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, "findAssetsInDomain");
                        }
                        catch (InvalidParameterException | UserNotAuthorizedException notVisible) {
                            asset = null;
                        }
                        if (asset == null) continue;
                        AssetSearchMatches assetSearchMatches = new AssetSearchMatches(asset);
                        Map assetEntityMap = (Map)organizedEntities.get(assetGUID);
                        ArrayList<MetadataElementSummary> anchoredElements = new ArrayList<MetadataElementSummary>();
                        for (EntityDetail anchoredEntity : assetEntityMap.values()) {
                            MetadataElementSummary metadataElement = (MetadataElementSummary)converter.getNewBean(MetadataElementSummary.class, anchoredEntity, "findAssetsInDomain");
                            anchoredElements.add(metadataElement);
                        }
                        assetSearchMatches.setMatchingElements(anchoredElements);
                        assetSearchMatchesList.add(assetSearchMatches);
                    }
                    response.setSearchMatches(assetSearchMatchesList);
                    break block9;
                }
                this.restExceptionHandler.handleNoRequestBody(userId, "findAssetsInDomain", serverName);
            }
            catch (Throwable error) {
                this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findAssetsInDomain", auditLog);
            }
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse findAssets(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String searchStringParameter = "searchString";
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            if (requestBody != null) {
                response.setGUIDs(handler.findAssetGUIDs(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findAssets"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findAssets", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String nameParameterName = "name";
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            if (requestBody != null) {
                response.setGUIDs(handler.getAssetGUIDsByName(userId, OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getAssetsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAssetsByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetsResponse getAssetsByMetadataCollectionId(String serverName, String userId, String metadataCollectionId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String nameParameterName = "metadataCollectionId";
        String methodName = "getAssetsByMetadataCollectionId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByMetadataCollectionId");
        AssetsResponse response = new AssetsResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByMetadataCollectionId");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByMetadataCollectionId");
            if (requestBody != null) {
                response.setAssets(handler.getAssetsByMetadataCollectionId(userId, requestBody.getName(), metadataCollectionId, "metadataCollectionId", startFrom, pageSize, false, false, new Date(), "getAssetsByMetadataCollectionId"));
            } else {
                response.setAssets(handler.getAssetsByMetadataCollectionId(userId, null, metadataCollectionId, "metadataCollectionId", startFrom, pageSize, false, false, new Date(), "getAssetsByMetadataCollectionId"));
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetsByMetadataCollectionId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addRatingToAsset(String serverName, String userId, String guid, RatingRequestBody requestBody) {
        String methodName = "addRatingToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addRatingToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                RatingHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getRatingHandler(userId, serverName, "addRatingToAsset");
                int starRating = StarRating.NOT_RECOMMENDED.getOrdinal();
                if (requestBody.getStarRating() != null) {
                    starRating = requestBody.getStarRating().getOrdinal();
                }
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToAsset");
                handler.saveRating(userId, null, null, guid, "guid", starRating, requestBody.getReview(), requestBody.getIsPublic(), false, false, new Date(), "addRatingToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addRatingToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addRatingToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeRatingFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRatingFromAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeRatingFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            RatingHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getRatingHandler(userId, serverName, "removeRatingFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromAsset");
            handler.removeRating(userId, null, null, guid, "guid", false, false, new Date(), "removeRatingFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeRatingFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLikeToAsset(String serverName, String userId, String guid, FeedbackRequestBody requestBody) {
        String methodName = "addLikeToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLikeToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LikeHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getLikeHandler(userId, serverName, "addLikeToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToAsset");
                handler.saveLike(userId, null, null, guid, "guid", requestBody.getIsPublic(), false, false, new Date(), "addLikeToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLikeToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addLikeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLikeFromAsset(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLikeFromAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeLikeFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            LikeHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getLikeHandler(userId, serverName, "removeLikeFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromAsset");
            handler.removeLike(userId, null, null, guid, "guid", false, false, new Date(), "removeLikeFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeLikeFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentToAsset(String serverName, String userId, String guid, CommentRequestBody requestBody) {
        String methodName = "addCommentToAsset";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOrdinal();
                }
                CommentHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getCommentHandler(userId, serverName, "addCommentToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToAsset");
                response.setGUID(handler.attachNewComment(userId, null, null, guid, guid, "guid", commentType, requestBody.getCommentText(), requestBody.getIsPublic(), null, null, false, false, new Date(), "addCommentToAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addCommentToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String userId, String assetGUID, String commentGUID, CommentRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "addCommentReply";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentReply");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOrdinal();
                }
                CommentHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getCommentHandler(userId, serverName, "addCommentReply");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentReply");
                response.setGUID(handler.attachNewComment(userId, null, null, assetGUID, commentGUID, "commentGUID", commentType, requestBody.getCommentText(), requestBody.getIsPublic(), null, null, false, false, new Date(), "addCommentReply"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addCommentReply", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String userId, String assetGUID, String commentGUID, CommentRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "updateComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                int commentType = CommentType.STANDARD_COMMENT.getOrdinal();
                if (requestBody.getCommentType() != null) {
                    commentType = requestBody.getCommentType().getOrdinal();
                }
                CommentHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getCommentHandler(userId, serverName, "updateComment");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
                handler.updateComment(userId, null, null, commentGUID, "commentGUID", null, commentType, requestBody.getCommentText(), requestBody.getIsPublic(), true, null, null, false, false, new Date(), "updateComment");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommentFromAsset(String serverName, String userId, String assetGUID, String commentGUID, NullRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "removeAssetComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAssetComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CommentHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getCommentHandler(userId, serverName, "removeAssetComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAssetComment");
            handler.removeCommentFromElement(userId, null, null, commentGUID, "commentGUID", false, false, new Date(), "removeAssetComment");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeAssetComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MeaningResponse getMeaning(String serverName, String userId, String guid) {
        String guidParameterName = "guid";
        String methodName = "getMeaning";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeaning");
        MeaningResponse response = new MeaningResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaning");
            response.setMeaning((MeaningElement)glossaryTermHandler.getTerm(userId, guid, "guid", false, false, new Date(), "getMeaning"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMeaning", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MeaningsResponse getMeaningByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getMeaningByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeaningByName");
        MeaningsResponse response = new MeaningsResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "getMeaningByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeaningByName");
            if (requestBody != null) {
                ArrayList<InstanceStatus> limitStatuses = new ArrayList<InstanceStatus>();
                limitStatuses.add(InstanceStatus.ACTIVE);
                response.setElements(glossaryTermHandler.getTermsByName(userId, null, requestBody.getName(), limitStatuses, startFrom, pageSize, false, false, new Date(), "getMeaningByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMeaningByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMeaningByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MeaningsResponse findMeanings(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findMeanings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMeanings");
        MeaningsResponse response = new MeaningsResponse();
        AuditLog auditLog = null;
        try {
            GlossaryTermHandler<MeaningElement> glossaryTermHandler = instanceHandler.getGlossaryTermHandler(userId, serverName, "findMeanings");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMeanings");
            if (requestBody != null) {
                ArrayList<InstanceStatus> limitStatuses = new ArrayList<InstanceStatus>();
                limitStatuses.add(InstanceStatus.ACTIVE);
                response.setElements(glossaryTermHandler.findTerms(userId, null, requestBody.getSearchString(), limitStatuses, startFrom, pageSize, false, false, new Date(), "findMeanings"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMeanings", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findMeanings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByMeaning(String serverName, String userId, String termGUID, int startFrom, int pageSize) {
        String guidParameterName = "termGUID";
        String methodName = "getAssetsByMeaning";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByMeaning");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByMeaning");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByMeaning");
            List attachedEntities = handler.getAttachedEntities(userId, termGUID, "termGUID", OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataType.REFERENCEABLE.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getAssetsByMeaning");
            if (attachedEntities != null) {
                String entityGUIDParameterName = "attachedEntity.getGUID";
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getAssetsByMeaning");
                ArrayList<String> guids = new ArrayList<String>();
                for (EntityDetail entity : attachedEntities) {
                    if (repositoryHelper.isTypeOf(serverName, entity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                        if (guids.contains(entity.getGUID())) continue;
                        guids.add(entity.getGUID());
                        continue;
                    }
                    EntityDetail anchorEntity = handler.validateEntityAndAnchorForRead(userId, OpenMetadataType.OPEN_METADATA_ROOT.typeName, entity, "attachedEntity.getGUID", false, false, false, false, handler.getSupportedZones(), new Date(), "getAssetsByMeaning");
                    if (anchorEntity == null || !repositoryHelper.isTypeOf(serverName, anchorEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName) || guids.contains(anchorEntity.getGUID())) continue;
                    guids.add(anchorEntity.getGUID());
                }
                response.setGUIDs(guids);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetsByMeaning", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLogMessageToAsset(String serverName, String userId, String guid, LogRecordRequestBody requestBody) {
        String methodName = "addLogMessageToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLogMessageToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LoggingHandler loggingHandler = instanceHandler.getLoggingHandler(userId, serverName, "addLogMessageToAsset");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLogMessageToAsset");
                loggingHandler.addLogMessageToAsset(userId, guid, requestBody.getConnectorInstanceId(), requestBody.getConnectionName(), requestBody.getConnectorType(), requestBody.getContextId(), requestBody.getMessage());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLogMessageToAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addLogMessageToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createTag(String serverName, String userId, InformalTagProperties requestBody) {
        String methodName = "createTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTag");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createTag(userId, null, null, requestBody.getName(), requestBody.getDescription(), !requestBody.getIsPrivateTag(), null, null, new Date(), "createTag"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String userId, String tagGUID, TagUpdateRequestBody requestBody) {
        String methodName = "updateTagDescription";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTagDescription");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, null, null, tagGUID, "tagGUID", requestBody.getDescription(), null, null, false, false, new Date(), "updateTagDescription");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateTagDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String userId, String tagGUID, NullRequestBody requestBody) {
        String methodName = "deleteTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            handler.deleteTag(userId, null, null, tagGUID, "tagGUID", false, false, new Date(), "deleteTag");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagResponse getTag(String serverName, String userId, String guid) {
        String methodName = "getTag";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTag");
        InformalTagResponse response = new InformalTagResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            response.setElement((InformalTagElement)handler.getTag(userId, guid, "guid", false, false, new Date(), "getTag"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getTagsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            if (requestBody != null) {
                response.setElements(handler.getTagsByName(userId, requestBody.getName(), "tagName", startFrom, pageSize, false, false, new Date(), "getTagsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getTagsByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getMyTagsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getMyTagsByName";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMyTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            if (requestBody != null) {
                response.setElements(handler.getMyTagsByName(userId, requestBody.getName(), "tagName", startFrom, pageSize, false, false, new Date(), "getMyTagsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMyTagsByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMyTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findTags(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findTags";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            if (requestBody != null) {
                response.setElements(handler.findTags(userId, requestBody.getSearchString(), "tagName", startFrom, pageSize, false, false, new Date(), "findTags"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findTags", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findMyTags(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findMyTags";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMyTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            if (requestBody != null) {
                response.setElements(handler.findMyTags(userId, requestBody.getSearchString(), "tagName", startFrom, pageSize, false, false, new Date(), "findMyTags"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMyTags", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToAsset(String serverName, String userId, String assetGUID, String tagGUID, FeedbackRequestBody requestBody) {
        String methodName = "addTagToAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToAsset");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "addTagToAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToAsset");
            handler.addTagToElement(userId, null, null, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "addTagToAsset"), isPublic, null, null, false, false, new Date(), "addTagToAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addTagToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToElement(String serverName, String userId, String elementGUID, String tagGUID, FeedbackRequestBody requestBody) {
        String methodName = "addTagToElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToElement");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "addTagToElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToElement");
            handler.addTagToElement(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, tagGUID, "tagGUID", isPublic, null, null, false, false, new Date(), "addTagToElement");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addTagToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromAsset(String serverName, String userId, String assetGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "removeTagFromAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromAsset");
            handler.removeTagFromElement(userId, null, null, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "removeTagFromAsset"), false, false, new Date(), "removeTagFromAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeTagFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromElement(String serverName, String userId, String elementGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "removeTagFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromElement");
            handler.removeTagFromElement(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "removeTagFromElement"), false, false, new Date(), "removeTagFromElement");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeTagFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByTag(String serverName, String userId, String tagGUID, int startFrom, int pageSize) {
        String methodName = "getAssetsByTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByTag");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByTag");
            response.setGUIDs(handler.getAssetGUIDsByTag(userId, tagGUID, "tagGUID", startFrom, pageSize, false, false, new Date(), "getAssetsByTag"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetsByTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    record LineageLink(Set<String> relationshipTypes, Set<String> informationSupplyChains) {
    }
}

