/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server.spring;

import org.odpi.openmetadata.accessservices.assetconsumer.rest.CommentRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.RatingRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/asset-consumer/users/{userId}"})
public class AssetConsumerOMASResource {
    private AssetConsumerRESTServices restAPI = new AssetConsumerRESTServices();

    @RequestMapping(method={RequestMethod.GET}, path={"/connections/by-name/{name}"})
    public ConnectionResponse getConnectionByName(@PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getConnectionByName(userId, name);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/connections/{guid}"})
    public ConnectionResponse getConnectionByGUID(@PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getConnectionByGUID(userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/log-records"})
    public VoidResponse addLogMessageToAsset(@PathVariable String userId, @PathVariable String guid, @RequestBody LogRecordRequestBody requestBody) {
        return this.restAPI.addLogMessageToAsset(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/tags"})
    public GUIDResponse addTagToAsset(@PathVariable String userId, @PathVariable String guid, @RequestBody TagRequestBody requestBody) {
        return this.restAPI.addTagToAsset(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/tags/private"})
    public GUIDResponse addPrivateTagToAsset(@PathVariable String userId, @PathVariable String guid, @RequestBody TagRequestBody requestBody) {
        return this.restAPI.addPrivateTagToAsset(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/ratings"})
    public GUIDResponse addRatingToAsset(@PathVariable String userId, @PathVariable String guid, @RequestBody RatingRequestBody requestBody) {
        return this.restAPI.addRatingToAsset(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/likes/"})
    public GUIDResponse addLikeToAsset(@PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.addLikeToAsset(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/comments/"})
    public GUIDResponse addCommentToAsset(@PathVariable String userId, @PathVariable String guid, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.addCommentToAsset(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/comments/{commentGUID}/reply"})
    public GUIDResponse addCommentReply(@PathVariable String userId, @PathVariable String commentGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.addCommentReply(userId, commentGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/{guid}/delete"})
    public VoidResponse removeTag(@PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeTag(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/private/{guid}/delete"})
    public VoidResponse removePrivateTag(@PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removePrivateTag(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/ratings/{guid}/delete"})
    public VoidResponse removeRating(@PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeRating(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/likes/{guid}/delete"})
    public VoidResponse removeLike(@PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeLike(userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/comments/{guid}/delete"})
    public VoidResponse removeComment(@PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeComment(userId, guid, requestBody);
    }
}

