/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server.spring;

import org.odpi.openmetadata.accessservices.assetconsumer.rest.CommentRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MeaningListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MeaningResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ReviewRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-consumer/users/{userId}"})
public class AssetConsumerResource {
    private AssetConsumerRESTServices restAPI = new AssetConsumerRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/comments/{commentGUID}/replies"})
    public GUIDResponse addCommentReply(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.addCommentReply(serverName, userId, commentGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/comments"})
    public GUIDResponse addCommentToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.addCommentToAsset(serverName, userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/likes"})
    public GUIDResponse addLikeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.addLikeToAsset(serverName, userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/log-records"})
    public VoidResponse addLogMessageToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody LogRecordRequestBody requestBody) {
        return this.restAPI.addLogMessageToAsset(serverName, userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{guid}/reviews"})
    public GUIDResponse addReviewToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody ReviewRequestBody requestBody) {
        return this.restAPI.addReviewToAsset(serverName, userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/tags/{tagGUID}"})
    public VoidResponse addTagToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String tagGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.addTagToAsset(serverName, userId, assetGUID, tagGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/private"})
    public GUIDResponse createPrivateTag(@PathVariable String serverName, @PathVariable String userId, @RequestBody TagRequestBody requestBody) {
        return this.restAPI.createPrivateTag(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/public"})
    public GUIDResponse createPublicTag(@PathVariable String serverName, @PathVariable String userId, @RequestBody TagRequestBody requestBody) {
        return this.restAPI.createPublicTag(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/{guid}/delete"})
    public VoidResponse deleteTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.deleteTag(serverName, userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/by-connection/{connectionGUID}"})
    public GUIDResponse getAssetForConnectionGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID) {
        return this.restAPI.getAssetForConnection(serverName, userId, connectionGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/by-connection-name/{connectionName}"})
    public GUIDResponse getAssetForConnectionName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionName) {
        return this.restAPI.getAssetForConnection(serverName, userId, connectionName);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/connections/{guid}"})
    public ConnectionResponse getConnectionByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getConnectionByGUID(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/connections/by-name/{name}"})
    public ConnectionResponse getConnectionByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getConnectionByName(serverName, userId, name);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/meanings/by-name/{term}"})
    public MeaningListResponse getMeaningByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String term, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getMeaningByName(serverName, userId, term, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/meanings/{guid}"})
    public MeaningResponse getMeaning(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getMeaning(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/tags/{guid}"})
    public TagResponse getTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTag(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/tags/by-name/{tagName}"})
    public TagListResponse getTagsByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getTagsByName(serverName, userId, tagName, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/comments/{guid}/delete"})
    public VoidResponse removeCommentFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeCommentFromAsset(serverName, userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/likes/{guid}/delete"})
    public VoidResponse removeLikeFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeLikeFromAsset(serverName, userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/reviews/{guid}/delete"})
    public VoidResponse removeReviewFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeReviewFromAsset(serverName, userId, guid, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/tags/{tagGUID}/delete"})
    public VoidResponse removeTagFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String tagGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeTagFromAsset(serverName, userId, assetGUID, tagGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/comments/{commentGUID}/update"})
    public VoidResponse updateComment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.updateComment(serverName, userId, commentGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/reviews/{reviewGUID}/update"})
    public VoidResponse updateReviewOnAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String reviewGUID, @RequestBody ReviewRequestBody requestBody) {
        return this.restAPI.updateReviewOnAsset(serverName, userId, reviewGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/{tagGUID}/update"})
    public VoidResponse updateTagDescription(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody TagRequestBody requestBody) {
        return this.restAPI.updateTagDescription(serverName, userId, tagGUID, requestBody);
    }
}

