/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server.spring;

import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.FeedbackRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.GlossaryTermListResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.GlossaryTermResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RatingRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagsResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-consumer/users/{userId}"})
public class AssetConsumerResource {
    private AssetConsumerRESTServices restAPI = new AssetConsumerRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/comments/{commentGUID}/replies"})
    public GUIDResponse addCommentReply(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.addCommentReply(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/comments"})
    public GUIDResponse addCommentToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.addCommentToAsset(serverName, userId, assetGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/likes"})
    public VoidResponse addLikeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody FeedbackRequestBody requestBody) {
        return this.restAPI.addLikeToAsset(serverName, userId, assetGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/log-records"})
    public VoidResponse addLogMessageToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody LogRecordRequestBody requestBody) {
        return this.restAPI.addLogMessageToAsset(serverName, userId, assetGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/ratings"})
    public VoidResponse addRatingToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody RatingRequestBody requestBody) {
        return this.restAPI.addRatingToAsset(serverName, userId, assetGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/tags/{tagGUID}"})
    public VoidResponse addTagToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String tagGUID, @RequestBody FeedbackRequestBody requestBody) {
        return this.restAPI.addTagToAsset(serverName, userId, assetGUID, tagGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags"})
    public GUIDResponse createTag(@PathVariable String serverName, @PathVariable String userId, @RequestBody TagRequestBody requestBody) {
        return this.restAPI.createTag(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/{tagGUID}/delete"})
    public VoidResponse deleteTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.deleteTag(serverName, userId, tagGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/by-connection-name/{connectionName}"})
    public GUIDResponse getAssetForConnectionName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionName) {
        return this.restAPI.getAssetForConnectionName(serverName, userId, connectionName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/by-search-string"})
    public GUIDListResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String searchString) {
        return this.restAPI.findAssets(serverName, userId, searchString, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/by-meaning/{termGUID}"})
    public GUIDListResponse getAssetsByMeaning(@PathVariable String serverName, @PathVariable String userId, @PathVariable String termGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByMeaning(serverName, userId, termGUID, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/by-name"})
    public GUIDListResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String name) {
        return this.restAPI.getAssetsByName(serverName, userId, name, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/by-tag/{tagGUID}"})
    GUIDListResponse getAssetsByTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByTag(serverName, userId, tagGUID, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/connections/by-name/{name}"})
    public ConnectionResponse getConnectionByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody String name) {
        return this.restAPI.getConnectionByName(serverName, userId, name);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/meanings/by-name"})
    public GlossaryTermListResponse getMeaningByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String name) {
        return this.restAPI.getMeaningByName(serverName, userId, name, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/meanings/by-search-string"})
    public GlossaryTermListResponse findMeanings(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String name) {
        return this.restAPI.findMeanings(serverName, userId, name, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/meanings/{termGUID}"})
    public GlossaryTermResponse getMeaning(@PathVariable String serverName, @PathVariable String userId, @PathVariable String termGUID) {
        return this.restAPI.getMeaning(serverName, userId, termGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/tags/{tagGUID}"})
    public TagResponse getTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID) {
        return this.restAPI.getTag(serverName, userId, tagGUID);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/by-name"})
    public TagsResponse getTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String tagName) {
        return this.restAPI.getTagsByName(serverName, userId, tagName, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/private/by-name"})
    public TagsResponse getMyTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String tagName) {
        return this.restAPI.getMyTagsByName(serverName, userId, tagName, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/by-search-string"})
    public TagsResponse findTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String tagName) {
        return this.restAPI.findTags(serverName, userId, tagName, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/private/by-search-string"})
    public TagsResponse findMyTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String tagName) {
        return this.restAPI.findMyTags(serverName, userId, tagName, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/comments/{commentGUID}/delete"})
    public VoidResponse removeCommentFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeCommentFromAsset(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/likes/delete"})
    public VoidResponse removeLikeFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeLikeFromAsset(serverName, userId, assetGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/ratings/delete"})
    public VoidResponse removeRatingFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeRatingFromAsset(serverName, userId, assetGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/{assetGUID}/tags/{tagGUID}/delete"})
    public VoidResponse removeTagFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String tagGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeTagFromAsset(serverName, userId, assetGUID, tagGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"assets/{assetGUID}/comments/{commentGUID}/update"})
    public VoidResponse updateComment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.updateComment(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/tags/{tagGUID}/update"})
    public VoidResponse updateTagDescription(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody TagRequestBody requestBody) {
        return this.restAPI.updateTagDescription(serverName, userId, tagGUID, requestBody);
    }
}

