/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.CommentProperties;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.InformalTagProperties;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.RatingProperties;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.FeedbackRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GlossaryTermListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GlossaryTermResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagsResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-consumer/users/{userId}"})
@Tag(name="Asset Consumer OMAS", description="The Asset Consumer OMAS provides services to an individual who wants to work with assets such as: data stores, data sets and data feeds, reports, APIs, functions such as analytical services", externalDocs=@ExternalDocumentation(description="Asset Consumer Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/asset-consumer/"))
public class AssetConsumerResource {
    private AssetConsumerRESTServices restAPI = new AssetConsumerRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/assets/{assetGUID}/comments/{commentGUID}/replies"})
    public GUIDResponse addCommentReply(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody CommentProperties requestBody) {
        return this.restAPI.addCommentReply(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/comments"})
    public GUIDResponse addCommentToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody CommentProperties requestBody) {
        return this.restAPI.addCommentToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/likes"})
    public VoidResponse addLikeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody FeedbackRequestBody requestBody) {
        return this.restAPI.addLikeToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/log-records"})
    public VoidResponse addLogMessageToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody LogRecordRequestBody requestBody) {
        return this.restAPI.addLogMessageToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/ratings"})
    public VoidResponse addRatingToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody RatingProperties requestBody) {
        return this.restAPI.addRatingToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/tags/{tagGUID}"})
    public VoidResponse addTagToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String tagGUID, @RequestBody FeedbackRequestBody requestBody) {
        return this.restAPI.addTagToAsset(serverName, userId, assetGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/assets/elements/{elementGUID}/tags/{tagGUID}"})
    public VoidResponse addTagToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestBody FeedbackRequestBody requestBody) {
        return this.restAPI.addTagToElement(serverName, userId, elementGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/tags"})
    public GUIDResponse createTag(@PathVariable String serverName, @PathVariable String userId, @RequestBody InformalTagProperties requestBody) {
        return this.restAPI.createTag(serverName, userId, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/delete"})
    public VoidResponse deleteTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.deleteTag(serverName, userId, tagGUID, requestBody);
    }

    @GetMapping(path={"/assets/by-connection-name/{connectionName}"})
    public GUIDResponse getAssetForConnectionName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionName) {
        return this.restAPI.getAssetForConnectionName(serverName, userId, connectionName);
    }

    @PostMapping(path={"/assets/by-search-string"})
    public GUIDListResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String searchString) {
        return this.restAPI.findAssets(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/assets/by-meaning/{termGUID}"})
    public GUIDListResponse getAssetsByMeaning(@PathVariable String serverName, @PathVariable String userId, @PathVariable String termGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByMeaning(serverName, userId, termGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-name"})
    public GUIDListResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String name) {
        return this.restAPI.getAssetsByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/assets/by-tag/{tagGUID}"})
    public GUIDListResponse getAssetsByTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByTag(serverName, userId, tagGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/meanings/by-name"})
    public GlossaryTermListResponse getMeaningByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String name) {
        return this.restAPI.getMeaningByName(serverName, userId, name, startFrom, pageSize);
    }

    @PostMapping(path={"/meanings/by-search-string"})
    public GlossaryTermListResponse findMeanings(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String name) {
        return this.restAPI.findMeanings(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/meanings/{termGUID}"})
    public GlossaryTermResponse getMeaning(@PathVariable String serverName, @PathVariable String userId, @PathVariable String termGUID) {
        return this.restAPI.getMeaning(serverName, userId, termGUID);
    }

    @GetMapping(path={"/tags/{tagGUID}"})
    public TagResponse getTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID) {
        return this.restAPI.getTag(serverName, userId, tagGUID);
    }

    @PostMapping(path={"/tags/by-name"})
    public TagsResponse getTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String tagName) {
        return this.restAPI.getTagsByName(serverName, userId, tagName, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/private/by-name"})
    public TagsResponse getMyTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String tagName) {
        return this.restAPI.getMyTagsByName(serverName, userId, tagName, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/by-search-string"})
    public TagsResponse findTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String tagName) {
        return this.restAPI.findTags(serverName, userId, tagName, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/private/by-search-string"})
    public TagsResponse findMyTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String tagName) {
        return this.restAPI.findMyTags(serverName, userId, tagName, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/{assetGUID}/comments/{commentGUID}/delete"})
    public VoidResponse removeCommentFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeCommentFromAsset(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/likes/delete"})
    public VoidResponse removeLikeFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeLikeFromAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/ratings/delete"})
    public VoidResponse removeRatingFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeRatingFromAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/tags/{tagGUID}/delete"})
    public VoidResponse removeTagFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTagFromAsset(serverName, userId, assetGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/assets/elements/{elementGUID}/tags/{tagGUID}/delete"})
    public VoidResponse removeTagFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTagFromElement(serverName, userId, elementGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"assets/{assetGUID}/comments/{commentGUID}/update"})
    public VoidResponse updateComment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody CommentProperties requestBody) {
        return this.restAPI.updateComment(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/update"})
    public VoidResponse updateTagDescription(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody InformalTagProperties requestBody) {
        return this.restAPI.updateTagDescription(serverName, userId, tagGUID, requestBody);
    }
}

