/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetGraphResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetLineageGraphRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetLineageGraphResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetSearchMatchesListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CommentRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FeedbackRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformalTagResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformalTagsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LogRecordRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.MeaningResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MeaningsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RatingRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.TagUpdateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.InformalTagProperties;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-consumer/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Consumer OMAS", description="The Asset Consumer OMAS provides services to an individual who wants to work with assets such as: data stores, data sets and data feeds, reports, APIs, functions such as analytical services", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-consumer/overview/"))
public class AssetConsumerResource {
    private final AssetConsumerRESTServices restAPI = new AssetConsumerRESTServices();

    @GetMapping(path={"/description"})
    public RegisteredOMAGServiceResponse getServiceDescription(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getServiceDescription(serverName, userId);
    }

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    @Operation(summary="getOutTopicConnection", description="Return the connection object for connecting to the Asset Consumer's OMAS's out topic.", externalDocs=@ExternalDocumentation(description="Out Topics", url="https://egeria-project.org/concepts/out-topic/"))
    public OCFConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/assets/{assetGUID}/comments/{commentGUID}/replies"})
    @Operation(summary="addCommentReply", description="Adds a reply to a comment.", externalDocs=@ExternalDocumentation(description="Asset Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentReply(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.addCommentReply(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/comments"})
    @Operation(summary="addCommentToAsset", description="Creates a comment and attaches it to an asset.", externalDocs=@ExternalDocumentation(description="Asset Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.addCommentToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/likes"})
    @Operation(summary="addLikeToAsset", description="Creates a <i>like</i> object and attaches it to an asset.", externalDocs=@ExternalDocumentation(description="Asset Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addLikeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody FeedbackRequestBody requestBody) {
        return this.restAPI.addLikeToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/log-records"})
    @Operation(summary="addLogMessageToAsset", description="Creates an audit log record for the asset.  This log record is stored in the local server's Audit Log.", externalDocs=@ExternalDocumentation(description="Asset Log Record", url="https://egeria-project.org/concepts/asset-log-message/"))
    public VoidResponse addLogMessageToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody LogRecordRequestBody requestBody) {
        return this.restAPI.addLogMessageToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/ratings"})
    @Operation(summary="addRatingToAsset", description="Adds a star rating and optional review text to the asset.", externalDocs=@ExternalDocumentation(description="Asset Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addRatingToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody RatingRequestBody requestBody) {
        return this.restAPI.addRatingToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/tags/{tagGUID}"})
    @Operation(summary="addTagToAsset", description="Adds an informal tag (either private of public) to an asset.", externalDocs=@ExternalDocumentation(description="Asset Classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse addTagToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String tagGUID, @RequestBody FeedbackRequestBody requestBody) {
        return this.restAPI.addTagToAsset(serverName, userId, assetGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/assets/elements/{elementGUID}/tags/{tagGUID}"})
    @Operation(summary="addTagToElement", description="Adds an informal tag (either private of public) to an element attached to an asset - such as schema element, connection, ...", externalDocs=@ExternalDocumentation(description="Asset Classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse addTagToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestBody FeedbackRequestBody requestBody) {
        return this.restAPI.addTagToElement(serverName, userId, elementGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/tags"})
    @Operation(summary="createTag", description="Creates a new informal tag and returns the unique identifier for it.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public GUIDResponse createTag(@PathVariable String serverName, @PathVariable String userId, @RequestBody InformalTagProperties requestBody) {
        return this.restAPI.createTag(serverName, userId, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/delete"})
    @Operation(summary="deleteTag", description="Removes an informal tag from the repository.  All the tagging relationships to this informal tag are lost.  A private tag can be deleted by its creator and all the references are lost; a public tag can be deleted by anyone, but only if it is not attached to any referenceable.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse deleteTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteTag(serverName, userId, tagGUID, requestBody);
    }

    @GetMapping(path={"/assets/by-connection-name/{connectionName}"})
    @Operation(summary="getAssetForConnectionName", description="Returns the unique identifier for the asset connected to the connection identified by the supplied name.", externalDocs=@ExternalDocumentation(description="Asset Connections", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-connections"))
    public GUIDResponse getAssetForConnectionName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionName) {
        return this.restAPI.getAssetForConnectionName(serverName, userId, connectionName);
    }

    @GetMapping(path={"/assets/{assetGUID}/as-graph"})
    @Operation(summary="getAssetGraph", description="Return all the elements that are anchored to an asset plus relationships between these elements and to other elements.", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public AssetGraphResponse getAssetGraph(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize) {
        return this.restAPI.getAssetGraph(serverName, userId, assetGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/{assetGUID}/as-lineage-graph"})
    @Operation(summary="getAssetLineageGraph", description="Return all the elements that are linked to an asset using lineage relationships.  The relationships are retrieved both from the asset, and the anchored schema elements.", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/features/lineage-management/overview/"))
    public AssetLineageGraphResponse getAssetLineageGraph(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) AssetLineageGraphRequestBody requestBody) {
        return this.restAPI.getAssetLineageGraph(serverName, userId, assetGUID, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/assets-in-domain/by-search-string"})
    @Operation(summary="findAssetsInDomain", description="Locate string value in elements that are anchored to assets.  The search string is a regular expression (regEx).", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public AssetSearchMatchesListResponse findAssetsInDomain(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findAssetsInDomain(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-search-string"})
    @Operation(summary="findAssets", description="Return a list of assets with the requested search string in their name, qualified name or description.  The search string is a regular expression (regEx).", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public GUIDListResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findAssets(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/assets/by-meaning/{termGUID}"})
    @Operation(summary="getAssetsByMeaning", description="Return the list of unique identifiers for assets that are linked to a specific (meaning) either directly or via fields in the schema.", externalDocs=@ExternalDocumentation(description="Asset classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public GUIDListResponse getAssetsByMeaning(@PathVariable String serverName, @PathVariable String userId, @PathVariable String termGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByMeaning(serverName, userId, termGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-name"})
    @Operation(summary="getAssetsByName", description="Return a list of assets with the requested name either qualifiedName or name property.  There are no wildcards supported in this request.  The name must match exactly.", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public GUIDListResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getAssetsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-metadata-collection-id/{metadataCollectionId}"})
    @Operation(summary="getAssetsByMetadataCollectionId", description="Return a list of assets that come from the requested metadata collection.", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public AssetsResponse getAssetsByMetadataCollectionId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataCollectionId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.getAssetsByMetadataCollectionId(serverName, userId, metadataCollectionId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/assets/by-tag/{tagGUID}"})
    @Operation(summary="getAssetsByTag", description="Return the list of unique identifiers for assets that are linked to a specific tag either directly, or via one of its schema elements.", externalDocs=@ExternalDocumentation(description="Asset classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public GUIDListResponse getAssetsByTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByTag(serverName, userId, tagGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/meanings/by-name"})
    @Operation(summary="getMeaningByName", description="Return the full definition (meaning) of the terms exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Glossaries", url="https://egeria-project.org/practices/common-data-definitions/anatomy-of-a-glossary/"))
    public MeaningsResponse getMeaningByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMeaningByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/meanings/by-search-string"})
    @Operation(summary="findMeanings", description="Return the full definition (meaning) of the terms matching the supplied name.  The search string is a regular expression (regEx).", externalDocs=@ExternalDocumentation(description="Glossaries", url="https://egeria-project.org/practices/common-data-definitions/anatomy-of-a-glossary/"))
    public MeaningsResponse findMeanings(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMeanings(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/meanings/{termGUID}"})
    @Operation(summary="getMeaning", description="Return the full definition (meaning) of a term using the unique identifier of the glossary term.", externalDocs=@ExternalDocumentation(description="Glossaries", url="https://egeria-project.org/practices/common-data-definitions/anatomy-of-a-glossary/"))
    public MeaningResponse getMeaning(@PathVariable String serverName, @PathVariable String userId, @PathVariable String termGUID) {
        return this.restAPI.getMeaning(serverName, userId, termGUID);
    }

    @GetMapping(path={"/tags/{tagGUID}"})
    @Operation(summary="getTag", description="Return the informal tag for the supplied unique identifier (tagGUID).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagResponse getTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID) {
        return this.restAPI.getTag(serverName, userId, tagGUID);
    }

    @PostMapping(path={"/tags/by-name"})
    @Operation(summary="getTagsByName", description="Return the tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getTagsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/private/by-name"})
    @Operation(summary="getMyTagsByName", description="Return the list of the calling user's private informal tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getMyTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMyTagsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/by-search-string"})
    @Operation(summary="findTags", description="Return the list of informal tags containing the supplied string in either the name or description. The search string is a regular expression (RegEx).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findTags(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/private/by-search-string"})
    @Operation(summary="findMyTags", description="Return the list of the calling user's private tags containing the supplied string in either the name or description.  The search string is a regular expression (RegEx).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findMyTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMyTags(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/{assetGUID}/comments/{commentGUID}/delete"})
    @Operation(summary="removeCommentFromAsset", description="Removes a comment added to the asset by this user.  This deletes the link to the comment, the comment itself and any comment replies attached to it.", externalDocs=@ExternalDocumentation(description="Asset Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeCommentFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeCommentFromAsset(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/likes/delete"})
    @Operation(summary="removeLikeFromAsset", description="Removes a <i>Like</i> added to the asset by this user.", externalDocs=@ExternalDocumentation(description="Asset Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeLikeFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeLikeFromAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/ratings/delete"})
    @Operation(summary="removeRatingFromAsset", description="Removes of a star rating/review that was added to the asset by this user.", externalDocs=@ExternalDocumentation(description="Asset Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeRatingFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeRatingFromAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/tags/{tagGUID}/delete"})
    @Operation(summary="removeTagFromAsset", description="Removes a link between a tag and an asset that was added by this user.", externalDocs=@ExternalDocumentation(description="Asset classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse removeTagFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTagFromAsset(serverName, userId, assetGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/assets/elements/{elementGUID}/tags/{tagGUID}/delete"})
    @Operation(summary="removeTagFromElement", description="Removes a tag from an element attached to an asset - such as schema element, connection, ... that was added by this user.", externalDocs=@ExternalDocumentation(description="Asset classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse removeTagFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTagFromElement(serverName, userId, elementGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"assets/{assetGUID}/comments/{commentGUID}/update"})
    @Operation(summary="updateComment", description="Update an existing comment.", externalDocs=@ExternalDocumentation(description="Asset Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse updateComment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestBody CommentRequestBody requestBody) {
        return this.restAPI.updateComment(serverName, userId, assetGUID, commentGUID, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/update"})
    @Operation(summary="updateTagDescription", description="Updates the description of an existing tag (either private or public).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse updateTagDescription(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody TagUpdateRequestBody requestBody) {
        return this.restAPI.updateTagDescription(serverName, userId, tagGUID, requestBody);
    }
}

