/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerEventInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerEventListener;
import org.odpi.openmetadata.accessservices.assetconsumer.events.AssetConsumerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetConsumerOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements AssetConsumerEventInterface {
    private static final Logger log = LoggerFactory.getLogger(AssetConsumerOutTopicClientConnector.class);
    private List<AssetConsumerEventListener> internalEventListeners = new ArrayList<AssetConsumerEventListener>();

    public synchronized void registerListener(String userId, AssetConsumerEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(AssetConsumerErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                AssetConsumerOutTopicEvent eventObject = (AssetConsumerOutTopicEvent)super.getEventBean(event, AssetConsumerOutTopicEvent.class);
                for (AssetConsumerEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

