/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.samples.createcsvfile;

import org.odpi.openmetadata.accessservices.assetowner.client.CSVFileAssetOwner;

public class CreateCSVFileAssetSample {
    private String fileName;
    private String serverName;
    private String serverURLRoot;
    private String clientUserId;

    public CreateCSVFileAssetSample(String fileName, String serverName, String serverURLRoot, String clientUserId) {
        this.fileName = fileName;
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    void run() {
        try {
            CSVFileAssetOwner client = new CSVFileAssetOwner(this.serverName, this.serverURLRoot);
            client.addCSVFileToCatalog(this.clientUserId, this.fileName, "This is a new file asset created by the CreateCSVFileAssetSample.", this.fileName);
        }
        catch (Throwable error) {
            System.out.println("The asset metadata can not be created.  Error message is: " + error.getMessage());
        }
    }

    public static void main(String[] args) {
        String fileName = "open-metadata-resources/open-metadata-samples/access-services-samples/asset-management-samples/ContactList.csv";
        String serverName = "cocoMDS1";
        String serverURLRoot = "https://localhost:9444";
        String clientUserId = "peterprofile";
        if (args.length > 0) {
            fileName = args[0];
        }
        if (args.length > 1) {
            serverName = args[1];
        }
        if (args.length > 2) {
            serverURLRoot = args[2];
        }
        if (args.length > 3) {
            clientUserId = args[3];
        }
        System.out.println("===============================");
        System.out.println("CSV File Asset Creation   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        System.out.println("Creating file: " + fileName);
        System.out.println();
        try {
            CreateCSVFileAssetSample sample = new CreateCSVFileAssetSample(fileName, serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Throwable error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

