/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;

public class AssetContext {
    private Set<LineageEntity> vertices = new HashSet<LineageEntity>();
    private Set<GraphContext> edges = new HashSet<GraphContext>();
    private Map<String, Set<GraphContext>> neighbors = new HashMap<String, Set<GraphContext>>();

    public boolean addVertex(LineageEntity Vertex2) {
        return this.vertices.add(Vertex2);
    }

    public boolean addEdge(GraphContext edge) {
        if (!this.edges.add(edge)) {
            return false;
        }
        String guid = edge.getFromVertex().getGuid();
        this.neighbors.putIfAbsent(guid, new HashSet());
        this.neighbors.get(guid).add(edge);
        return true;
    }

    public Set<LineageEntity> getVertices() {
        return this.vertices;
    }

    public Set<GraphContext> getEdges() {
        return this.edges;
    }

    public void setEdges(Set<GraphContext> edges) {
        this.edges = edges;
    }

    public Map<String, Set<GraphContext>> getNeighbors() {
        return this.neighbors;
    }

    public String toString() {
        return "AssetContext{vertices=" + this.vertices + ", edges=" + this.edges + ", neighbors=" + this.neighbors + '}';
    }
}

