// Generated by delombok at Wed Jun 02 13:48:30 UTC 2021
/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.assetlineage.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineagePublishSummary;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageSyncUpdateContext;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;
/**
 * The lineage event contains information used for internal processing of data
 *
 */
/**
 * LineageSyncEvent is used to notify external consumers about AssetLineage internal processing.
 * It can contain details such as publishSummary and/or updateSummary created by corresponding internal processing phases of AssetLineage.
 */
@JsonAutoDetect(getterVisibility = PUBLIC_ONLY, setterVisibility = PUBLIC_ONLY, fieldVisibility = NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LineageSyncEvent extends AssetLineageEventHeader {
    /**
     * LineagePublishSummary is used to describe summary as result of AssetLineage lineagePublish activity that completed.
     */
    private LineagePublishSummary publishSummary;
    private LineageSyncUpdateContext syncUpdateContext;

    /**
     * LineagePublishSummary is used to describe summary as result of AssetLineage lineagePublish activity that completed.
     */
    @java.lang.SuppressWarnings("all")
    public LineagePublishSummary getPublishSummary() {
        return this.publishSummary;
    }

    @java.lang.SuppressWarnings("all")
    public LineageSyncUpdateContext getSyncUpdateContext() {
        return this.syncUpdateContext;
    }

    /**
     * LineagePublishSummary is used to describe summary as result of AssetLineage lineagePublish activity that completed.
     */
    @java.lang.SuppressWarnings("all")
    public void setPublishSummary(final LineagePublishSummary publishSummary) {
        this.publishSummary = publishSummary;
    }

    @java.lang.SuppressWarnings("all")
    public void setSyncUpdateContext(final LineageSyncUpdateContext syncUpdateContext) {
        this.syncUpdateContext = syncUpdateContext;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LineageSyncEvent)) return false;
        final LineageSyncEvent other = (LineageSyncEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$publishSummary = this.getPublishSummary();
        final java.lang.Object other$publishSummary = other.getPublishSummary();
        if (this$publishSummary == null ? other$publishSummary != null : !this$publishSummary.equals(other$publishSummary)) return false;
        final java.lang.Object this$syncUpdateContext = this.getSyncUpdateContext();
        final java.lang.Object other$syncUpdateContext = other.getSyncUpdateContext();
        if (this$syncUpdateContext == null ? other$syncUpdateContext != null : !this$syncUpdateContext.equals(other$syncUpdateContext)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LineageSyncEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $publishSummary = this.getPublishSummary();
        result = result * PRIME + ($publishSummary == null ? 43 : $publishSummary.hashCode());
        final java.lang.Object $syncUpdateContext = this.getSyncUpdateContext();
        result = result * PRIME + ($syncUpdateContext == null ? 43 : $syncUpdateContext.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "LineageSyncEvent(publishSummary=" + this.getPublishSummary() + ", syncUpdateContext=" + this.getSyncUpdateContext() + ")";
    }
}
