// Generated by delombok at Wed Jun 02 13:48:30 UTC 2021
/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.assetlineage.model;

import java.util.Set;

/**
 * SyncUpdateContext contains the context for syncing the relationships of a node after an update.
 */
public class LineageSyncUpdateContext {
    /**
     * The list GUIDs for the items published after lineage processing activity completed.
     */
    private String entityGUID;
    /**
     * The list GUIDs of the nodes that have a direct relationship to the entityGUID
     */
    private Set<String> neighboursGUID;

    /**
     * Get the GUID of the entity that was updated
     * @return the GUID of the entity that was updated
     */
    @java.lang.SuppressWarnings("all")
    public String getEntityGUID() {
        return this.entityGUID;
    }

    /**
     * Get the list of GUIDs of nodes directly connected to the entity
     * @return the list of GUIDs of nodes directly connected to the entity
     */
    @java.lang.SuppressWarnings("all")
    public Set<String> getNeighboursGUID() {
        return this.neighboursGUID;
    }

    /**
     * Set the entity that was updated.
     * @param entityGUID of the entity that was updated
     */
    @java.lang.SuppressWarnings("all")
    public void setEntityGUID(final String entityGUID) {
        this.entityGUID = entityGUID;
    }

    /**
     * Set the list of neighbours
     * @param neighboursGUID list of node related to the entity
     */
    @java.lang.SuppressWarnings("all")
    public void setNeighboursGUID(final Set<String> neighboursGUID) {
        this.neighboursGUID = neighboursGUID;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LineageSyncUpdateContext)) return false;
        final LineageSyncUpdateContext other = (LineageSyncUpdateContext) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$entityGUID = this.getEntityGUID();
        final java.lang.Object other$entityGUID = other.getEntityGUID();
        if (this$entityGUID == null ? other$entityGUID != null : !this$entityGUID.equals(other$entityGUID)) return false;
        final java.lang.Object this$neighboursGUID = this.getNeighboursGUID();
        final java.lang.Object other$neighboursGUID = other.getNeighboursGUID();
        if (this$neighboursGUID == null ? other$neighboursGUID != null : !this$neighboursGUID.equals(other$neighboursGUID)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LineageSyncUpdateContext;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $entityGUID = this.getEntityGUID();
        result = result * PRIME + ($entityGUID == null ? 43 : $entityGUID.hashCode());
        final java.lang.Object $neighboursGUID = this.getNeighboursGUID();
        result = result * PRIME + ($neighboursGUID == null ? 43 : $neighboursGUID.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "LineageSyncUpdateContext(entityGUID=" + this.getEntityGUID() + ", neighboursGUID=" + this.getNeighboursGUID() + ")";
    }
}
