/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.model;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;

public class FindEntitiesParameters {
    private Long updatedAfter;
    private List<String> entitySubtypeGUIDs;
    private List<InstanceStatus> limitResultsByStatus;
    private SearchClassifications searchClassifications;
    private String sequencingProperty;
    private SequencingOrder sequencingOrder;

    private FindEntitiesParameters(Long updatedAfter, List<String> entitySubtypeGUIDs, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, String sequencingProperty, SequencingOrder sequencingOrder) {
        this.updatedAfter = updatedAfter;
        this.entitySubtypeGUIDs = entitySubtypeGUIDs;
        this.limitResultsByStatus = limitResultsByStatus;
        this.searchClassifications = searchClassifications;
        this.sequencingProperty = sequencingProperty;
        this.sequencingOrder = sequencingOrder;
    }

    public Long getUpdatedAfter() {
        return this.updatedAfter;
    }

    public List<String> getEntitySubtypeGUIDs() {
        return this.entitySubtypeGUIDs;
    }

    public List<InstanceStatus> getLimitResultsByStatus() {
        return this.limitResultsByStatus;
    }

    public SearchClassifications getSearchClassifications() {
        return this.searchClassifications;
    }

    public String getSequencingProperty() {
        return this.sequencingProperty;
    }

    public SequencingOrder getSequencingOrder() {
        return this.sequencingOrder;
    }

    public static class Builder {
        private Long updatedAfter;
        private List<String> entitySubtypeGUIDs;
        private List<InstanceStatus> limitResultsByStatus;
        private SearchClassifications searchClassifications;
        private String sequencingProperty;
        private SequencingOrder sequencingOrder;

        public Builder withEntitySubtypeGUIDs(List<String> entitySubtypeGUIDs) {
            this.entitySubtypeGUIDs = entitySubtypeGUIDs;
            return this;
        }

        public Builder withLimitResultsByStatus(List<InstanceStatus> limitResultsByStatus) {
            this.limitResultsByStatus = limitResultsByStatus;
            return this;
        }

        public Builder withSearchClassifications(SearchClassifications searchClassifications) {
            this.searchClassifications = searchClassifications;
            return this;
        }

        public Builder withSequencingProperty(String sequencingProperty) {
            this.sequencingProperty = sequencingProperty;
            return this;
        }

        public Builder withSequencingOrder(SequencingOrder sequencingOrder) {
            this.sequencingOrder = sequencingOrder;
            return this;
        }

        public Builder withUpdatedAfter(LocalDateTime updatedAfterDate) {
            this.updatedAfter = updatedAfterDate != null ? Long.valueOf(updatedAfterDate.atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli()) : Long.valueOf(0L);
            return this;
        }

        public FindEntitiesParameters build() {
            return new FindEntitiesParameters(this.updatedAfter, this.entitySubtypeGUIDs, this.limitResultsByStatus, this.searchClassifications, this.sequencingProperty, this.sequencingOrder);
        }
    }
}

