/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum AssetLineageEventType implements Serializable
{
    PROCESS_CONTEXT_EVENT(0, "ProcessContextEvent", "Has the full context for a Process"),
    CLASSIFICATION_CONTEXT_EVENT(1, "ClassificationContextEvent", "Has the full context for a classified element"),
    UPDATE_ENTITY_EVENT(2, "UpdateEvent", "Has the entity that is being updated"),
    DELETE_ENTITY_EVENT(3, "DeleteEvent", "Has the entity to be deleted"),
    NEW_RELATIONSHIP_EVENT(4, "NewRelationship", "Has the relationship that is being created"),
    UPDATE_RELATIONSHIP_EVENT(5, "UpdateRelationship", "Has the relationship that is being updated"),
    DELETE_RELATIONSHIP_EVENT(6, "DeleteRelationship", "Has the relationship to be deleted"),
    DECLASSIFIED_ENTITY_EVENT(7, "DeclassifiedEntityEvent", "All relevant lineage classifications for this entity have been removed"),
    RECLASSIFIED_ENTITY_EVENT(8, "ReclassifiedEntityEvent", "Has the full context for a classified element"),
    SEMANTIC_ASSIGNMENTS_EVENT(9, "SemanticAssignmentsEvent", "Has the semantic assignments for a glossary term"),
    TERM_CATEGORIZATIONS_EVENT(10, "TermCategorizationsEvent", "Has the term categorizations for a glossary term"),
    TERM_ANCHORS_EVENT(11, "TermAnchorEvent", "Has the term anchor for a glossary term"),
    CATEGORY_ANCHORS_EVENT(12, "GlossaryCategoriesEvent", "Has the categorizations for an anchor"),
    COLUMN_CONTEXT_EVENT(13, "ColumnContextEvent", "Has the context for a column"),
    ASSET_CONTEXT_EVENT(14, "AssetContextEvent", "Has the asset context for a relational table or a data file"),
    LINEAGE_MAPPINGS_EVENT(15, "LineageMappingsEvent", "Has the linege mappings for a column"),
    UNKNOWN_ASSET_LINEAGE_EVENT(100, "UnknownAssetLineageEvent", "An AssetLineage OMAS event that is not recognized by the local handlers.");

    private static final long serialVersionUID = 1L;
    private int eventTypeCode;
    private String eventTypeName;
    private String eventTypeDescription;

    private AssetLineageEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public static AssetLineageEventType getByEventTypeName(String eventTypeName) {
        return Arrays.stream(AssetLineageEventType.values()).filter(v -> v.eventTypeName.equals(eventTypeName)).findAny().orElse(null);
    }
}

