/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;

public class AssetContext {
    private Set<LineageEntity> vertices = new HashSet<LineageEntity>();
    private Set<GraphContext> graphContexts = new HashSet<GraphContext>();
    private Map<String, Set<GraphContext>> neighbors = new HashMap<String, Set<GraphContext>>();

    public boolean addVertex(LineageEntity Vertex) {
        return this.vertices.add(Vertex);
    }

    public boolean addGraphContext(GraphContext graphContext) {
        if (!this.graphContexts.add(graphContext)) {
            return false;
        }
        String guid = graphContext.getFromVertex().getGuid();
        this.neighbors.putIfAbsent(guid, new HashSet());
        this.neighbors.get(guid).add(graphContext);
        return true;
    }

    public Set<LineageEntity> getVertices() {
        return this.vertices;
    }

    public Set<GraphContext> getGraphContexts() {
        return this.graphContexts;
    }

    public void setGraphContexts(Set<GraphContext> graphContexts) {
        this.graphContexts = graphContexts;
    }

    public Map<String, Set<GraphContext>> getNeighbors() {
        return this.neighbors;
    }

    public String toString() {
        return "AssetContext{vertices=" + this.vertices + ", graphContexts=" + this.graphContexts + ", neighbors=" + this.neighbors + "}";
    }
}

