/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum AssetLineageErrorCode implements ExceptionMessageSet
{
    ASSET_NOT_FOUND(404, "OMAS-ASSET-LINEAGE-005 ", "The requested asset {0} is not found in OMAS Server {1}", "The system is unable to populate the requested asset.", "Check that the unique identifier for the asset is correct."),
    OMRS_NOT_INITIALIZED(404, "OMAS-ASSET-LINEAGE-006 ", "The open metadata repository services are not initialized for server {0}", "The system is unable to connect to the open metadata property server.", "Check that the server initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    OMRS_NOT_AVAILABLE(404, "OMAS-ASSET-LINEAGE-007 ", "The open metadata repository services are not available for the {0} operation", "The system is unable to connect to the open metadata property server.", "Check that the server where the Asset Lineage OMAS is running initialized correctly and is not in the process of shutting down.  Correct any errors discovered and retry the request when the open metadata services are available."),
    BAD_OUT_TOPIC_CONNECTION(400, "OMAS-ASSET-LINEAGE-008", "The Asset Lineage Open Metadata Access Service (OMAS) has been passed an invalid connection for publishing events.  The connection was {0}.  The resulting exception of {1} included the following message: {2}", "The access service has not been passed valid configuration for its out topic connection.", "Correct the configuration and restart the server."),
    ENTITY_NOT_FOUND(404, "OMAS-ASSET-LINEAGE-404-009", "Cannot get entity from repository, entity does not exist.", "The system is unable to get the full context for the queried entity.", "Check if the entity queried is available on the repository in the cohort."),
    RELATIONSHIP_NOT_FOUND(404, "OMAS-ASSET-LINEAGE-404-010", "Cannot get the relationships from repository, relationship does not exist.", "The system is unable to get the relationships for the queried entity.", "Check if the relationship queried is available on the repository in the cohort."),
    CLASSIFICATION_MAPPING_ERROR(400, "OMAS-ASSET-LINEAGE-404-011 ", "The attempt to map a lineage entity and a classification failed for classification {0}", "The system was unable to perform the classification mapping request.", "Correct the caller's code and retry the request."),
    NULL_LISTENER(500, "OMAS-ASSET-LINEAGE-500-001", "A null topic listener has been passed by user {0} on method {1}", "There is a coding error in the caller to the Asset Lineage OMAS.", "Correct the caller logic and retry the request.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private AssetLineageErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

