/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.assetlineage.AssetLineageInterface;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class AssetLineage
extends FFDCRESTClient
implements AssetLineageInterface {
    private static final String BASE_PATH = "/servers/{0}/open-metadata/access-services/asset-lineage/users/{1}/";
    private static final String PUBLISH_ENTITIES = "publish-entities/{2}";
    private static final String PUBLISH_CONTEXT = "publish-context/{2}/{3}";
    private static final String UPDATED_AFTER_DATE = "?updatedAfterDate={3}";
    private String userId;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public AssetLineage(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public AssetLineage(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
        this.userId = userId;
    }

    @Override
    public List<String> publishEntities(String serverName, String userId, String entityType, Optional<Date> updatedAfterDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GUIDListResponse response;
        String methodName = "publishEntities";
        this.invalidParameterHandler.validateUserId(methodName, userId);
        String urlTemplate = this.serverPlatformURLRoot + BASE_PATH + PUBLISH_ENTITIES;
        if (updatedAfterDate.isPresent()) {
            String updatedAfterAsString = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(updatedAfterDate.get());
            response = this.callGUIDListGetRESTCall(methodName, urlTemplate + UPDATED_AFTER_DATE, new Object[]{serverName, userId, entityType, updatedAfterAsString});
        } else {
            response = this.callGUIDListGetRESTCall(methodName, urlTemplate, new Object[]{serverName, userId, entityType});
        }
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)response);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)response);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)response);
        return response.getGUIDs();
    }

    @Override
    public List<String> publishAssetContext(String userId, String guid, String entityType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "publishAssetContext";
        this.invalidParameterHandler.validateUserId(methodName, userId);
        String urlTemplate = this.serverPlatformURLRoot + BASE_PATH + PUBLISH_CONTEXT;
        GUIDListResponse response = (GUIDListResponse)this.callGetRESTCall(methodName, GUIDListResponse.class, urlTemplate, new Object[]{this.serverName, userId, entityType, guid});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)response);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)response);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)response);
        return response.getGUIDs();
    }
}

