/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.assetlineage.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.Edge;
import org.odpi.openmetadata.accessservices.assetlineage.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHandler {
    private static final Logger log = LoggerFactory.getLogger(CommonHandler.class);
    private static final String GUID_PARAMETER = "guid";
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;

    public CommonHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
    }

    public Optional<EntityDetail> getEntityDetails(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        return Optional.ofNullable(this.repositoryHandler.getEntityByGUID(userId, guid, GUID_PARAMETER, "Process", methodName));
    }

    public List<Relationship> getRelationshipByType(String userId, String assetGuid, String relationshipType, String typeDefName) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationshipByType";
        String typeGuid = this.getTypeName(userId, relationshipType);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, assetGuid, typeDefName, typeGuid, relationshipType, "getRelationshipByType");
        if (relationships != null) {
            return relationships;
        }
        return new ArrayList<Relationship>();
    }

    public String getTypeName(String userId, String typeDefName) {
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        if (typeDefByName != null) {
            return typeDefByName.getGUID();
        }
        return null;
    }

    public EntityDetail getEntityAtTheEnd(String userId, String entityDetailGUID, Relationship relationship) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityAtTheEnd";
        if (relationship.getEntityOneProxy().getGUID().equals(entityDetailGUID)) {
            return this.repositoryHandler.getEntityByGUID(userId, relationship.getEntityTwoProxy().getGUID(), GUID_PARAMETER, "Any entity type", methodName);
        }
        return this.repositoryHandler.getEntityByGUID(userId, relationship.getEntityOneProxy().getGUID(), GUID_PARAMETER, "Any entity type", methodName);
    }

    protected EntityDetail writeEntitiesAndRelationships(String userId, EntityDetail startEntity, Relationship relationship, AssetContext graph) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Converter converter = new Converter();
        EntityDetail endEntity = this.getEntityAtTheEnd(userId, startEntity.getGUID(), relationship);
        if (endEntity == null) {
            return null;
        }
        LineageEntity startVertex = converter.createEntity(startEntity);
        LineageEntity endVertex = converter.createEntity(endEntity);
        graph.addVertex(startVertex);
        graph.addVertex(endVertex);
        Edge edge = new Edge(relationship.getType().getTypeDefName(), startVertex, endVertex);
        graph.addEdge(edge);
        return endEntity;
    }
}

