/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.assetlineage.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.CommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHandler {
    private static final Logger log = LoggerFactory.getLogger(ContextHandler.class);
    private static final String GUID_PARAMETER = "guid";
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private CommonHandler commonHandler;
    private AssetContext graph;

    public ContextHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.commonHandler = new CommonHandler(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler);
    }

    public AssetContext getAssetContext(String serverName, String userId, String guid) {
        this.graph = new AssetContext();
        try {
            Optional<EntityDetail> entityDetail = this.getEntityDetails(userId, guid);
            if (!entityDetail.isPresent()) {
                log.error("Something is wrong in the OMRS Connector when a specific operation is performed in the metadata collection. Entity not found with guid {}", (Object)guid);
                throw new AssetLineageException(AssetLineageErrorCode.ENTITY_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Entity", AssetLineageErrorCode.ENTITY_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getUserAction());
            }
            this.buildAssetContext(userId, entityDetail.get());
            return this.graph;
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException | InvalidParameterException | RepositoryErrorException | org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private Optional<EntityDetail> getEntityDetails(String userId, String guid) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        return Optional.ofNullable(this.repositoryHandler.getEntityByGUID(userId, guid, GUID_PARAMETER, "Any entity type", methodName));
    }

    private void buildAssetContext(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, RepositoryErrorException, InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String typeDefName = entityDetail.getType().getTypeDefName();
        Optional<TypeDef> isComplexSchemaType = this.isComplexSchemaType(userId, typeDefName);
        if (isComplexSchemaType.isPresent()) {
            // empty if block
        }
        if (this.hasSchemaType(typeDefName)) {
            this.getRelationshipsBetweenEntities(userId, entityDetail, "SchemaAttributeType", typeDefName);
        }
        List<EntityDetail> attributeForSchemas = this.getRelationshipsBetweenEntities(userId, entityDetail, "AttributeForSchema", typeDefName);
        for (EntityDetail attributeForSchema : attributeForSchemas) {
            if (this.isComplexSchemaType(userId, attributeForSchema.getType().getTypeDefName()).isPresent()) {
                this.setAssetDetails(userId, attributeForSchema);
                continue;
            }
            List<EntityDetail> schemaAttributeTypeEntities = this.getRelationshipsBetweenEntities(userId, attributeForSchema, "SchemaAttributeType", attributeForSchema.getType().getTypeDefName());
            for (EntityDetail schema : schemaAttributeTypeEntities) {
                this.buildAssetContext(userId, schema);
            }
        }
    }

    private List<EntityDetail> getRelationshipsBetweenEntities(String userId, EntityDetail startEntity, String relationshipType, String typeDefName) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        List<Relationship> relationships = this.commonHandler.getRelationshipByType(userId, startEntity.getGUID(), relationshipType, typeDefName);
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship : relationships) {
            EntityDetail endEntity = this.commonHandler.writeEntitiesAndRelationships(userId, startEntity, relationship, this.graph);
            if (endEntity == null) {
                return Collections.emptyList();
            }
            entityDetails.add(endEntity);
        }
        return entityDetails;
    }

    private void setAssetDetails(String userId, EntityDetail startEntity) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> dataSet = this.getRelationshipsBetweenEntities(userId, startEntity, "AssetSchemaType", startEntity.getType().getTypeDefName());
        Optional first = dataSet.stream().findFirst();
        if (first.isPresent()) {
            this.getAsset(userId, (EntityDetail)first.get());
        }
    }

    private void getAsset(String userId, EntityDetail dataSet) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeDefName = dataSet.getType().getTypeDefName();
        if (typeDefName.equals("DataFile")) {
            this.getRelationshipsBetweenEntities(userId, dataSet, "NestedFile", typeDefName);
        } else {
            this.getRelationshipsBetweenEntities(userId, dataSet, "DataContentForDataSet", typeDefName);
        }
    }

    private Optional<TypeDef> isComplexSchemaType(String userId, String typeDefName) throws RepositoryErrorException, InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        TypeDefGallery allTypes = this.repositoryHandler.getMetadataCollection().getAllTypes(userId);
        return allTypes.getTypeDefs().stream().filter(t -> t.getName().equals(typeDefName) && t.getSuperType().getName().equals("ComplexSchemaType")).findAny();
    }

    private boolean hasSchemaType(String typeDefName) {
        ArrayList<String> entitiesWithScehmaTypes = new ArrayList<String>(Arrays.asList("TabularColumn", "RelationalColumn"));
        return entitiesWithScehmaTypes.contains(typeDefName);
    }
}

