/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.CommonHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.GlossaryHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ProcessHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetLineageServicesInstance
extends OCFOMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.ASSET_LINEAGE_OMAS;
    private GlossaryHandler glossaryHandler;
    private ContextHandler contextHandler;
    private CommonHandler commonHandler;
    private ProcessHandler processHandler;

    public AssetLineageServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, OMRSAuditLog auditLog) throws NewInstanceException {
        super(myDescription.getAccessServiceName() + " OMAS", repositoryConnector, auditLog);
        String methodName = "new ServiceInstance";
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            AssetLineageErrorCode errorCode = AssetLineageErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.glossaryHandler = new GlossaryHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler);
        this.contextHandler = new ContextHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler);
        this.commonHandler = new CommonHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler);
        this.processHandler = new ProcessHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler);
    }

    GlossaryHandler getGlossaryHandler() {
        return this.glossaryHandler;
    }

    ContextHandler getContextHandler() {
        return this.contextHandler;
    }

    CommonHandler getCommonHandler() {
        return this.commonHandler;
    }

    ProcessHandler getProcessHandler() {
        return this.processHandler;
    }
}

