/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.assetlineage.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.CommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHandler {
    private static final Logger log = LoggerFactory.getLogger(ContextHandler.class);
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private CommonHandler commonHandler;
    private AssetContext graph;

    public ContextHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.commonHandler = new CommonHandler(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler);
    }

    public AssetContext getAssetContext(String serverName, String userId, String guid, String type) {
        String methodName = "getAssetContext";
        this.graph = new AssetContext();
        try {
            this.invalidParameterHandler.validateUserId(userId, methodName);
            this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
            Optional<EntityDetail> entityDetail = this.getEntityDetails(userId, guid, type);
            if (!entityDetail.isPresent()) {
                log.error("Something is wrong in the OMRS Connector when a specific operation is performed in the metadata collection. Entity not found with guid {}", (Object)guid);
                throw new AssetLineageException(AssetLineageErrorCode.ENTITY_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Entity", AssetLineageErrorCode.ENTITY_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getUserAction());
            }
            this.buildAssetContext(userId, entityDetail.get());
            return this.graph;
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException | InvalidParameterException | RepositoryErrorException | org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private Optional<EntityDetail> getEntityDetails(String userId, String guid, String type) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        return Optional.ofNullable(this.repositoryHandler.getEntityByGUID(userId, guid, "guid", type, methodName));
    }

    private void buildAssetContext(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, RepositoryErrorException, InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String typeDefName = entityDetail.getType().getTypeDefName();
        Optional<TypeDef> isComplexSchemaType = this.isComplexSchemaType(userId, typeDefName);
        if (isComplexSchemaType.isPresent()) {
            // empty if block
        }
        if (this.hasSchemaAttributeType(typeDefName)) {
            this.buildGraphByRelationshipType(userId, entityDetail, "LineageMapping", typeDefName);
        }
        List<EntityDetail> schemaTypeEntities = this.buildGraphByRelationshipType(userId, entityDetail, "AttributeForSchema", typeDefName);
        for (EntityDetail schemaTypeEntity : schemaTypeEntities) {
            if (this.isComplexSchemaType(userId, schemaTypeEntity.getType().getTypeDefName()).isPresent()) {
                this.setAssetDetails(userId, schemaTypeEntity);
                continue;
            }
            this.buildAssetContext(userId, schemaTypeEntity);
        }
    }

    private List<EntityDetail> buildGraphByRelationshipType(String userId, EntityDetail startEntity, String relationshipType, String typeDefName) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        List<Relationship> relationships = this.commonHandler.getRelationshipsByType(userId, startEntity.getGUID(), relationshipType, typeDefName);
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship : relationships) {
            EntityDetail endEntity = this.commonHandler.buildGraphEdgeByRelationship(userId, startEntity, relationship, this.graph);
            if (endEntity == null) {
                return Collections.emptyList();
            }
            entityDetails.add(endEntity);
        }
        return entityDetails;
    }

    private void setAssetDetails(String userId, EntityDetail startEntity) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> assetEntity = this.buildGraphByRelationshipType(userId, startEntity, "AssetSchemaType", startEntity.getType().getTypeDefName());
        Optional first = assetEntity.stream().findFirst();
        if (first.isPresent()) {
            this.getAsset(userId, (EntityDetail)first.get());
        }
    }

    private void getAsset(String userId, EntityDetail dataSet) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeDefName = dataSet.getType().getTypeDefName();
        if (typeDefName.equals("DataFile")) {
            this.buildGraphByRelationshipType(userId, dataSet, "NestedFile", typeDefName);
        } else {
            this.buildGraphByRelationshipType(userId, dataSet, "DataContentForDataSet", typeDefName);
        }
    }

    private Optional<TypeDef> isComplexSchemaType(String userId, String typeDefName) throws RepositoryErrorException, InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        TypeDefGallery allTypes = this.repositoryHandler.getMetadataCollection().getAllTypes(userId);
        return allTypes.getTypeDefs().stream().filter(t -> t.getName().equals(typeDefName) && t.getSuperType().getName().equals("ComplexSchemaType")).findAny();
    }

    private boolean hasSchemaAttributeType(String typeDefName) {
        ArrayList<String> entitiesWithSchemaTypes = new ArrayList<String>(Arrays.asList("TabularColumn", "RelationalColumn"));
        return entitiesWithSchemaTypes.contains(typeDefName);
    }
}

