/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.listeners;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ClassificationHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.GlossaryHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ProcessHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.model.assetContext.AssetLineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.AssetLineageEntityEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.DeletePurgedRelationshipEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.LineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageInstanceHandler;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageOMRSTopicListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageOMRSTopicListener.class);
    private static AssetLineageInstanceHandler instanceHandler = new AssetLineageInstanceHandler();
    private OMRSRepositoryValidator repositoryValidator;
    private OMRSRepositoryHelper repositoryHelper;
    private String componentName;
    private List<String> supportedZones;
    private AssetLineagePublisher publisher;
    private String serverName;
    private String serverUserName;

    public AssetLineageOMRSTopicListener(Connection assetLineageOutTopic, OMRSRepositoryValidator repositoryValidator, OMRSRepositoryHelper repositoryHelper, String componentName, List<String> supportedZones, OMRSAuditLog auditLog, String serverUserName, String serverName) throws OMAGConfigurationErrorException {
        this.repositoryValidator = repositoryValidator;
        this.repositoryHelper = repositoryHelper;
        this.componentName = componentName;
        this.supportedZones = supportedZones;
        this.serverName = serverName;
        this.serverUserName = serverUserName;
        this.publisher = new AssetLineagePublisher(assetLineageOutTopic, auditLog);
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.debug("Ignoring registry event: " + event.toString());
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.debug("Ignoring type event: " + event.toString());
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        String serviceOperationName = "processInstanceEvent";
        log.debug("Processing instance event" + instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - Asset LIneage OMAS is ignoring the event");
        } else {
            OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
            OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
            if (instanceEventOriginator != null) {
                switch (instanceEventType) {
                    case NEW_ENTITY_EVENT: {
                        this.processNewEntityEvent(instanceEvent.getEntity(), "processInstanceEvent");
                        break;
                    }
                    case UPDATED_ENTITY_EVENT: {
                        this.processUpdatedEntityEvent(instanceEvent.getEntity(), "processInstanceEvent");
                        break;
                    }
                    case CLASSIFIED_ENTITY_EVENT: {
                        this.processClassifiedEntityEvent(instanceEvent.getEntity(), "processInstanceEvent");
                        break;
                    }
                    case NEW_RELATIONSHIP_EVENT: {
                        break;
                    }
                }
            }
        }
    }

    public void processNewEntityEvent(EntityDetail entityDetail, String serviceOperationName) {
        String typeDefName = entityDetail.getType().getTypeDefName();
        if (!this.isValidEntityEvent(typeDefName)) {
            log.info("Event is ignored as the entity is not relevant type for the Asset Lineage OMAS.");
        } else {
            this.processNewEntity(entityDetail, serviceOperationName);
        }
    }

    private void processUpdatedEntityEvent(EntityDetail entityDetail, String serviceOperationName) {
        if (entityDetail.getType().getTypeDefName().equals("Process") && entityDetail.getStatus().getName().equals("Active")) {
            this.processNewEntity(entityDetail, serviceOperationName);
        }
    }

    private void processClassifiedEntityEvent(EntityDetail entityDetail, String serviceOperationName) {
        String methodName = "processClassifiedEntityEvent";
        String typeDefName = entityDetail.getType().getTypeDefName();
        try {
            if (this.isValidEntityEvent(typeDefName)) {
                this.getClassificationContext(entityDetail, serviceOperationName);
            } else {
                log.info("Event is ignored as the process is not a ready yet");
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("Exception in processing the classified entities for the access service failed at {}, Exception message is: {}", (Object)methodName, (Object)e.getMessage());
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private void processNewEntity(EntityDetail entityDetail, String serviceOperationName) {
        String methodName = "processNewEntity";
        try {
            if (entityDetail.getType().getTypeDefName().equals("Process")) {
                this.getContextForProcess(entityDetail, serviceOperationName);
            } else {
                this.getAssetContext(entityDetail, serviceOperationName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("Retrieving handler for the access service failed at {}, Exception message is: {}", (Object)"processNewEntity", (Object)e.getMessage());
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private void getClassificationContext(EntityDetail entityDetail, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ClassificationHandler classificationHandler = instanceHandler.getClassificationHandler(this.serverUserName, this.serverName, serviceOperationName);
        Map<String, Set<GraphContext>> classificationContext = classificationHandler.getAssetContextByClassification(this.serverName, this.serverUserName, entityDetail);
        if (!classificationContext.isEmpty()) {
            LineageEvent event = new LineageEvent();
            event.setAssetContext(classificationContext);
            event.setAssetLineageEventType(AssetLineageEventType.CLASSIFICATION_CONTEXT_EVENT);
            this.publisher.publishRelationshipEvent((AssetLineageEvent)event);
        }
    }

    private void getContextForProcess(EntityDetail entityDetail, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ProcessHandler processHandler = instanceHandler.getProcessHandler(this.serverUserName, this.serverName, serviceOperationName);
        Map<String, Set<GraphContext>> processContext = processHandler.getProcessContext(this.serverUserName, entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setAssetContext(processContext);
        event.setAssetLineageEventType(AssetLineageEventType.PROCESS_CONTEXT_EVENT);
        this.publisher.publishRelationshipEvent((AssetLineageEvent)event);
    }

    private void getAssetContext(EntityDetail entityDetail, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String technicalGuid = entityDetail.getGUID();
        ContextHandler newContextHandler = instanceHandler.getContextHandler(this.serverUserName, this.serverName, serviceOperationName);
        AssetContext assetContext = newContextHandler.getAssetContext(this.serverName, this.serverUserName, technicalGuid, entityDetail.getType().getTypeDefName());
        GlossaryHandler glossaryHandler = instanceHandler.getGlossaryHandler(this.serverUserName, this.serverName, serviceOperationName);
        Map<String, Set<GraphContext>> context = glossaryHandler.getGlossaryTerm(technicalGuid, serviceOperationName, entityDetail, assetContext);
        LineageEvent event = new LineageEvent();
        if (context.size() != 0) {
            event.setAssetContext(context);
        } else {
            event.setAssetContext(assetContext.getNeighbors());
        }
        event.setAssetLineageEventType(AssetLineageEventType.TECHNICAL_ELEMENT_CONTEXT_EVENT);
        this.publisher.publishRelationshipEvent((AssetLineageEvent)event);
    }

    private boolean isValidEntityEvent(String typeDefName) {
        List<String> types = Arrays.asList("GlossaryTerm", "TabularSchemaType", "TabularColumn", "RelationalColumn", "RelationalTable", "DataFile");
        return types.contains(typeDefName);
    }

    private boolean isValidRelationshipEvent(Relationship relationship) {
        String entityProxyOneType = relationship.getEntityOneProxy().getType().getTypeDefName();
        if (relationship.getType().getTypeDefName().equals("SemanticAssignment") && (entityProxyOneType.equals("RelationalColumn") || entityProxyOneType.equals("RelationalTable") || entityProxyOneType.equals("TabularColumn"))) {
            return true;
        }
        List<String> types = Arrays.asList("ProcessPort", "PortDelegation", "PortSchema", "SchemaType", "AttributeForSchema", "LineageMapping");
        return types.contains(relationship.getType().getTypeDefName());
    }

    private void processSemanticAssignment(Relationship relationship, String serviceOperationName) {
    }

    private void processDeletedPurgedRelationship(Relationship relationship, String serviceOperationName) {
        if (!this.isValidRelationshipEvent(relationship)) {
            log.info("Event is ignored as the relationship is not a semantic assignment for a column or table");
        } else {
            log.info("Processing semantic assignment deletion relationship event");
            this.processSemanticAssignmentDeletion(relationship, serviceOperationName);
        }
    }

    private void processSemanticAssignmentDeletion(Relationship relationship, String serviceOperationName) {
        DeletePurgedRelationshipEvent deletionEvent = new DeletePurgedRelationshipEvent();
        GlossaryHandler glossaryHandler = null;
        try {
            glossaryHandler = instanceHandler.getGlossaryHandler(this.serverUserName, this.serverName, serviceOperationName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("Retrieving glossaryHandler for the access setvice failed. Exception message is {}", (Object)e.getMessage());
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
        deletionEvent.setEntityGuid(relationship.getEntityOneProxy().getGUID());
        deletionEvent.setEntityTypeDef(relationship.getEntityOneProxy().getType().getTypeDefName());
        this.publisher.publishRelationshipEvent((AssetLineageEvent)deletionEvent);
    }

    private AssetLineageEntityEvent proxyToNewEntity(EntityProxy proxy) {
        String methodName = "proxyToNewEntity";
        AssetLineageEntityEvent assetLineageEntityEvent = new AssetLineageEntityEvent();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("qualifiedName", this.repositoryHelper.getStringProperty("AssetLineageOmas", "qualifiedName", proxy.getUniqueProperties(), "proxyToNewEntity"));
        assetLineageEntityEvent.setProperties(properties);
        assetLineageEntityEvent.setGUID(proxy.getGUID());
        assetLineageEntityEvent.setTypeDefName(proxy.getType().getTypeDefName());
        assetLineageEntityEvent.setCreateTime(proxy.getCreateTime());
        assetLineageEntityEvent.setCreatedBy(proxy.getCreatedBy());
        assetLineageEntityEvent.setVersion(proxy.getVersion());
        return assetLineageEntityEvent;
    }
}

