/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.CommonHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.util.Constants;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationHandler {
    private static final Logger log = LoggerFactory.getLogger(AssetContextHandler.class);
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private CommonHandler commonHandler;
    private AssetContext graph;

    public ClassificationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.invalidParameterHandler = invalidParameterHandler;
        this.commonHandler = new CommonHandler(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler);
    }

    public Map<String, Set<GraphContext>> getAssetContextByClassification(String serverName, String userId, EntityDetail entityDetail) {
        if (!entityDetail.getClassifications().isEmpty() && this.checkLineageClassificationTypes(entityDetail)) {
            this.graph = new AssetContext();
            String methodName = "getAssetContextByClassification";
            try {
                this.invalidParameterHandler.validateUserId(userId, methodName);
                this.invalidParameterHandler.validateGUID(entityDetail.getGUID(), "guid", methodName);
                this.buildGraphContextByClassificationType(entityDetail, this.graph);
                return this.graph.getNeighbors();
            }
            catch (InvalidParameterException e) {
                throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
            }
        }
        log.info("No valid lineage classification found from entity {} ", (Object)entityDetail.getGUID());
        return null;
    }

    private boolean checkLineageClassificationTypes(EntityDetail entityDetail) {
        for (String classificationType : Constants.qualifiedLineageClassifications) {
            if (!entityDetail.getClassifications().stream().anyMatch(classification -> classification.getName().equals(classificationType))) continue;
            return true;
        }
        return false;
    }

    private List<LineageEntity> buildGraphContextByClassificationType(EntityDetail classifiedEntity, AssetContext graph) {
        ArrayList<LineageEntity> classificationEntities = new ArrayList<LineageEntity>();
        if (classifiedEntity.getStatus() == InstanceStatus.ACTIVE) {
            for (Classification classification : classifiedEntity.getClassifications()) {
                if (!Constants.qualifiedLineageClassifications.contains(classification.getName())) continue;
                LineageEntity lineageClassificationEntity = new LineageEntity();
                lineageClassificationEntity.setGuid(classifiedEntity.getGUID());
                this.mapClassificationsToLineageEntity(classification, lineageClassificationEntity);
                classificationEntities.add(lineageClassificationEntity);
                log.debug("Adding Classification {} ", (Object)classification.toString());
            }
            Converter converter = new Converter();
            LineageEntity startVertex = converter.createLineageEntity(classifiedEntity);
            for (LineageEntity endVertex : classificationEntities) {
                graph.addVertex(startVertex);
                graph.addVertex(endVertex);
                GraphContext edge = new GraphContext(endVertex.getTypeDefName(), startVertex.getGuid(), startVertex, endVertex);
                graph.addEdge(edge);
            }
            return classificationEntities;
        }
        return null;
    }

    private void mapClassificationsToLineageEntity(Classification classification, LineageEntity lineageEntity) {
        String methodName = "mapClassificationsToLineageEntity";
        Converter converter = new Converter();
        try {
            lineageEntity.setVersion(classification.getVersion());
            lineageEntity.setTypeDefName(classification.getType().getTypeDefName());
            lineageEntity.setCreatedBy(classification.getCreatedBy());
            lineageEntity.setUpdatedBy(classification.getUpdatedBy());
            lineageEntity.setCreateTime(classification.getCreateTime());
            lineageEntity.setUpdateTime(classification.getUpdateTime());
            lineageEntity.setProperties(converter.getMapProperties(classification.getProperties()));
            log.debug("Classfication mapping for lineage entity {}: ", (Object)lineageEntity);
        }
        catch (Throwable exc) {
            AssetLineageErrorCode errorCode = AssetLineageErrorCode.CLASSIFICATION_MAPPING_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classification.getName(), "mapClassificationsToLineageEntity", this.getClass().getName()});
            log.error("Caught exception from classification mapper {}", (Object)errorMessage);
        }
    }
}

