/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHandler {
    private static final Logger log = LoggerFactory.getLogger(CommonHandler.class);
    private static final String GUID_PARAMETER = "guid";
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;

    public CommonHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
    }

    public Optional<EntityDetail> getEntityDetails(String userId, String guid, String typeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, GUID_PARAMETER, methodName);
        return Optional.ofNullable(this.repositoryHandler.getEntityByGUID(userId, guid, GUID_PARAMETER, typeName, methodName));
    }

    public List<Relationship> getRelationshipsByType(String userId, String assetGuid, String relationshipTypeName, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "getRelationshipsByType";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipsByType");
        this.invalidParameterHandler.validateGUID(assetGuid, GUID_PARAMETER, "getRelationshipsByType");
        String typeGuid = this.getTypeName(userId, relationshipTypeName);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, assetGuid, entityTypeName, typeGuid, relationshipTypeName, "getRelationshipsByType");
        if (relationships != null) {
            return relationships;
        }
        return new ArrayList<Relationship>();
    }

    public String getTypeName(String userId, String typeDefName) {
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        if (typeDefByName != null) {
            return typeDefByName.getGUID();
        }
        return null;
    }

    public EntityDetail getEntityAtTheEnd(String userId, String entityDetailGUID, Relationship relationship) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityAtTheEnd";
        if (relationship.getEntityOneProxy().getGUID().equals(entityDetailGUID)) {
            return this.repositoryHandler.getEntityByGUID(userId, relationship.getEntityTwoProxy().getGUID(), GUID_PARAMETER, relationship.getEntityTwoProxy().getType().getTypeDefName(), methodName);
        }
        return this.repositoryHandler.getEntityByGUID(userId, relationship.getEntityOneProxy().getGUID(), GUID_PARAMETER, relationship.getEntityOneProxy().getType().getTypeDefName(), methodName);
    }

    protected EntityDetail buildGraphEdgeByRelationship(String userId, EntityDetail startEntity, Relationship relationship, AssetContext graph, boolean changeDirection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        LineageEntity endVertex;
        LineageEntity startVertex;
        Converter converter = new Converter();
        EntityDetail endEntity = this.getEntityAtTheEnd(userId, startEntity.getGUID(), relationship);
        if (endEntity == null) {
            return null;
        }
        if (changeDirection) {
            startVertex = converter.createLineageEntity(endEntity);
            endVertex = converter.createLineageEntity(startEntity);
        } else {
            startVertex = converter.createLineageEntity(startEntity);
            endVertex = converter.createLineageEntity(endEntity);
        }
        GraphContext edge = new GraphContext(relationship.getType().getTypeDefName(), relationship.getGUID(), startVertex, endVertex);
        if (graph.getEdges().stream().noneMatch(e -> e.getRelationshipGuid().equals(edge.getRelationshipGuid()))) {
            graph.addVertex(startVertex);
            graph.addVertex(endVertex);
            graph.addEdge(edge);
        }
        return endEntity;
    }
}

