/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.CommonHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.util.Validator;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryHandler {
    private static final Logger log = LoggerFactory.getLogger(GlossaryHandler.class);
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private AssetContext graph = new AssetContext();
    private CommonHandler commonHandler;

    public GlossaryHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.commonHandler = new CommonHandler(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler);
    }

    public Map<String, Set<GraphContext>> getGlossaryTerm(String assetGuid, String userId, EntityDetail entityDetail, AssetContext assetContext, Validator validator) throws InvalidParameterException {
        String methodName = "getGlossaryTerm";
        this.invalidParameterHandler.validateGUID(assetGuid, "guid", methodName);
        try {
            this.graph = assetContext;
            Set vertices = assetContext.getVertices();
            vertices = vertices.stream().filter(vertex -> validator.getSuperTypes(vertex.getTypeDefName()).contains("SchemaElement") && !validator.getSuperTypes(vertex.getTypeDefName()).contains("ComplexSchemaType")).collect(Collectors.toSet());
            for (LineageEntity vertex2 : vertices) {
                this.getGlossary(userId, vertex2.getGuid(), vertex2.getTypeDefName());
            }
            return this.graph.getNeighbors();
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private void getGlossary(String userId, String assetGuid, String typeDefName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGlossary";
        String typeGuid = this.commonHandler.getTypeName(userId, "SemanticAssignment");
        List semanticAssignments = this.repositoryHandler.getRelationshipsByType(userId, assetGuid, typeDefName, typeGuid, "SemanticAssignment", "getGlossary");
        if (semanticAssignments == null) {
            return;
        }
        this.addSemanticAssignmentToContext(userId, semanticAssignments.toArray(new Relationship[0]));
    }

    private void addSemanticAssignmentToContext(String userId, Relationship ... semanticAssignments) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addSemanticAssignmentToContext";
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship : semanticAssignments) {
            String glossaryTermGuid = relationship.getEntityTwoProxy().getGUID();
            EntityDetail glossaryTerm = this.repositoryHandler.getEntityByGUID(userId, glossaryTermGuid, "guid", "GlossaryTerm", "addSemanticAssignmentToContext");
            entityDetails.add(this.commonHandler.buildGraphEdgeByRelationship(userId, glossaryTerm, relationship, this.graph, false));
        }
    }
}

