/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.CommonHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.util.Constants;
import org.odpi.openmetadata.accessservices.assetlineage.util.Validator;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessContextHandler {
    private static final Logger log = LoggerFactory.getLogger(ProcessContextHandler.class);
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private CommonHandler commonHandler;
    private AssetContext graph;
    private Validator validator;

    public ProcessContextHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.commonHandler = new CommonHandler(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler);
        this.validator = new Validator(repositoryHelper);
    }

    public Map<String, Set<GraphContext>> getProcessContext(String userId, String processGuid) {
        this.graph = new AssetContext();
        try {
            Optional<EntityDetail> entityDetail = this.commonHandler.getEntityDetails(userId, processGuid, "Process");
            if (!entityDetail.isPresent()) {
                log.error("Entity with guid {} was not found in any metadata repository", (Object)processGuid);
                throw new AssetLineageException(AssetLineageErrorCode.ENTITY_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Entity", AssetLineageErrorCode.ENTITY_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getUserAction());
            }
            return this.checkIfAllRelationshipsExist(userId, entityDetail.get());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private Map<String, Set<GraphContext>> checkIfAllRelationshipsExist(String userId, EntityDetail entityDetail) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        boolean entitiesTillLastRelationshipExist = this.hasEntitiesLinkedWithProcessPort(userId, entityDetail);
        if (entitiesTillLastRelationshipExist) {
            return this.graph.getNeighbors();
        }
        log.error("Some relationships are missing for the entity with guid {}", (Object)entityDetail.getGUID());
        throw new AssetLineageException(AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Relationships", AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getUserAction());
    }

    private boolean hasEntitiesLinkedWithProcessPort(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String typeDefName = entityDetail.getType().getTypeDefName();
        List<EntityDetail> entityDetails = this.getRelationshipsBetweenEntities(userId, entityDetail.getGUID(), "ProcessPort", typeDefName);
        if (entityDetails.isEmpty()) {
            log.error("No relationships Process Port has been found for the entity with guid {}", (Object)entityDetail.getGUID());
            throw new AssetLineageException(AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Relationship", AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getUserAction());
        }
        return this.hasRelationshipBasedOnType(entityDetails, userId);
    }

    private List<EntityDetail> getRelationshipsBetweenEntities(String userId, String guid, String relationshipType, String typeDefName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        List<Relationship> relationships = this.commonHandler.getRelationshipsByType(userId, guid, relationshipType, typeDefName);
        EntityDetail startEntity = this.repositoryHandler.getEntityByGUID(userId, guid, "guid", typeDefName, "getRelationships");
        if (startEntity == null) {
            return Collections.emptyList();
        }
        String startEntityType = startEntity.getType().getTypeDefName();
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship : relationships) {
            if (relationship.getType().getTypeDefName().equals("AttributeForSchema") && startEntityType.equals("TabularColumn")) continue;
            EntityDetail endEntity = this.commonHandler.buildGraphEdgeByRelationship(userId, startEntity, relationship, this.graph, false);
            if (endEntity == null) {
                return Collections.emptyList();
            }
            entityDetails.add(endEntity);
        }
        return entityDetails;
    }

    private boolean hasRelationshipBasedOnType(List<EntityDetail> entityDetails, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        boolean relationshipsExist = false;
        if (this.checkIfEntityExistWithSpecificType(entityDetails, "PortAlias")) {
            relationshipsExist = this.hasEndRelationship(entityDetails, userId);
        }
        if (this.checkIfEntityExistWithSpecificType(entityDetails, "PortImplementation")) {
            relationshipsExist = this.hasTabularSchemaTypes(entityDetails, userId);
        }
        return relationshipsExist;
    }

    private boolean hasEndRelationship(List<EntityDetail> entityDetails, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            result.addAll(this.getRelationshipsBetweenEntities(userId, entityDetail.getGUID(), Constants.processRelationshipsTypes.get(entityDetail.getType().getTypeDefName()), entityDetail.getType().getTypeDefName()));
        }
        return !result.isEmpty();
    }

    private boolean hasTabularSchemaTypes(List<EntityDetail> entityDetails, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            List<EntityDetail> tabularSchemaType = this.getRelationshipsBetweenEntities(userId, entityDetail.getGUID(), Constants.processRelationshipsTypes.get(entityDetail.getType().getTypeDefName()), entityDetail.getType().getTypeDefName());
            Optional first = tabularSchemaType.stream().findFirst();
            result.add(first.orElse(null));
        }
        return this.hasSchemaAttributes(result, userId);
    }

    private boolean hasSchemaAttributes(List<EntityDetail> entityDetails, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            List<EntityDetail> newListOfEntityDetails = this.getRelationshipsBetweenEntities(userId, entityDetail.getGUID(), Constants.processRelationshipsTypes.get(entityDetail.getType().getTypeDefName()), entityDetail.getType().getTypeDefName());
            result.addAll(newListOfEntityDetails);
        }
        return this.hasEndRelationship(result, userId);
    }

    private boolean checkIfEntityExistWithSpecificType(List<EntityDetail> entityDetails, String typeDefName) {
        return entityDetails.stream().anyMatch(entity -> entity.getType().getTypeDefName().equals(typeDefName));
    }
}

