/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.listeners;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ClassificationHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.GlossaryHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ProcessContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageInstanceHandler;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.accessservices.assetlineage.util.Validator;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageOMRSTopicListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageOMRSTopicListener.class);
    private static AssetLineageInstanceHandler instanceHandler = new AssetLineageInstanceHandler();
    private OMRSRepositoryValidator repositoryValidator;
    private OMRSRepositoryHelper repositoryHelper;
    private String componentName;
    private List<String> supportedZones;
    private AssetLineagePublisher publisher;
    private String serverName;
    private String serverUserName;
    private Converter converter = new Converter();
    private Validator validator;

    public AssetLineageOMRSTopicListener(Connection assetLineageOutTopic, OMRSRepositoryValidator repositoryValidator, OMRSRepositoryHelper repositoryHelper, String componentName, List<String> supportedZones, OMRSAuditLog auditLog, String serverUserName, String serverName) throws OMAGConfigurationErrorException {
        this.repositoryValidator = repositoryValidator;
        this.repositoryHelper = repositoryHelper;
        this.componentName = componentName;
        this.supportedZones = supportedZones;
        this.serverName = serverName;
        this.serverUserName = serverUserName;
        this.publisher = new AssetLineagePublisher(assetLineageOutTopic, auditLog);
        this.validator = new Validator(repositoryHelper);
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.debug("Ignoring registry event: " + event.toString());
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.debug("Ignoring type event: " + event.toString());
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        String serviceOperationName = "processOMRSInstanceEvent: ";
        log.debug("Processing instance event" + instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - Asset LIneage OMAS is ignoring the event");
        } else {
            OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
            OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
            if (instanceEventOriginator != null) {
                switch (instanceEventType) {
                    case NEW_ENTITY_EVENT: {
                        this.validateEventType(instanceEvent.getEntity(), "processOMRSInstanceEvent: " + OMRSInstanceEventType.NEW_ENTITY_EVENT.getName());
                        break;
                    }
                    case UPDATED_ENTITY_EVENT: {
                        this.processUpdatedEntityEvent(instanceEvent.getEntity(), "processOMRSInstanceEvent: " + OMRSInstanceEventType.UPDATED_ENTITY_EVENT.getName());
                        break;
                    }
                    case DELETED_ENTITY_EVENT: {
                        this.processDeleteEntity(instanceEvent.getEntity(), "processOMRSInstanceEvent: " + OMRSInstanceEventType.DELETED_ENTITY_EVENT.getName());
                    }
                }
            }
        }
    }

    private void validateEventType(EntityDetail entityDetail, String serviceOperationName) {
        if (this.validator.isValidLineageEntityEvent(entityDetail.getType().getTypeDefName())) {
            this.processNewEntity(entityDetail, serviceOperationName + OMRSInstanceEventType.NEW_ENTITY_EVENT.getName(), "SchemaElement");
        }
    }

    private void processUpdatedEntityEvent(EntityDetail entityDetail, String serviceOperationName) {
        log.debug("Asset Lineage OMAS start processing events for the following entity {}: ", (Object)entityDetail.getGUID());
        if (entityDetail.getType().getTypeDefName().equals("Process") && entityDetail.getStatus().getName().equals("Active")) {
            this.processNewEntity(entityDetail, serviceOperationName + OMRSInstanceEventType.NEW_ENTITY_EVENT.getName(), "Process");
        } else {
            this.processUpdatedEntity(entityDetail, serviceOperationName + OMRSInstanceEventType.UPDATED_ENTITY_EVENT.getName());
        }
    }

    private void processNewEntity(EntityDetail entityDetail, String serviceOperationName, String supertype) {
        String methodName = "processNewEntity";
        log.debug("Asset Lineage OMAS start processing new entity events for the following entity {}: ", (Object)entityDetail.getGUID());
        try {
            if (entityDetail.getType().getTypeDefName().equals("Process")) {
                this.getContextForProcess(entityDetail, serviceOperationName);
            } else {
                this.getAssetContext(entityDetail, serviceOperationName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("Retrieving handler for the access service failed at {}, Exception message is: {}", (Object)"processNewEntity", (Object)e.getMessage());
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private void processNewRelationship(EntityDetail entityDetail, String serviceOperationName) {
        String methodName = "processNewRelationship";
        log.debug("Asset Lineage OMAS start processing events with method {} for the following entity {}: ", (Object)"processNewRelationship", (Object)entityDetail.getGUID());
    }

    private void processUpdatedRelationshipEvent(EntityDetail entityDetail, String serviceOperationName) {
        String methodName = "processUpdatedRelationshipEvent";
        log.debug("Asset Lineage OMAS start processing events with method {} for the following entity {}: ", (Object)"processUpdatedRelationshipEvent", (Object)entityDetail.getGUID());
    }

    private void processDeletedRelationshipEvent(EntityDetail entityDetail, String serviceOperationName) {
        String methodName = "processDeletedRelationshipEvent";
        log.debug("Asset Lineage OMAS start processing events with method {} for the following entity {}: ", (Object)"processDeletedRelationshipEvent", (Object)entityDetail.getGUID());
    }

    private void processDeleteEntity(EntityDetail entityDetail, String serviceOperationName) {
        log.debug("Asset Lineage OMAS start processing events for deleting the following entity: {} ", (Object)entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.DELETE_ENTITY_EVENT);
        this.publisher.publishRelationshipEvent((AssetLineageEventHeader)event);
    }

    private void processClassifiedEntityEvent(EntityDetail entityDetail, String serviceOperationName) {
        String methodName = "processClassifiedEntityEvent";
        log.debug("Asset Lineage OMAS start processing events with method {} for the following entity {}: ", (Object)methodName, (Object)entityDetail.getGUID());
        String typeDefName = entityDetail.getType().getTypeDefName();
        try {
            if (this.validator.isValidLineageEntityEvent(typeDefName)) {
                this.getClassificationContext(entityDetail, serviceOperationName);
            } else {
                log.info("Event is ignored as the process is not a ready yet");
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("Exception in processing the classified entities for the access service failed at {}, Exception message is: {}", (Object)methodName, (Object)e.getMessage());
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private void processReclassifiedEntityEvent(EntityDetail entityDetail, String serviceOperationName) {
        String methodName = "processReclassifiedEntityEvent";
        log.debug("Asset Lineage OMAS start processing events with method {} for the following entity {}: ", (Object)methodName, (Object)entityDetail.getGUID());
    }

    private void processDeclassifiedEntityEvent(EntityDetail entityDetail, String serviceOperationName) {
        String methodName = "processDeclassifiedEntityEvent";
        log.debug("Asset Lineage OMAS start processing events with method {} for the following entity {}: ", (Object)methodName, (Object)entityDetail.getGUID());
    }

    private void getClassificationContext(EntityDetail entityDetail, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ClassificationHandler classificationHandler = instanceHandler.getClassificationHandler(this.serverUserName, this.serverName, serviceOperationName);
        Map<String, Set<GraphContext>> classificationContext = classificationHandler.getAssetContextByClassification(this.serverName, this.serverUserName, entityDetail);
        if (!classificationContext.isEmpty()) {
            LineageEvent event = new LineageEvent();
            event.setAssetContext(classificationContext);
            event.setAssetLineageEventType(AssetLineageEventType.CLASSIFICATION_CONTEXT_EVENT);
            this.publisher.publishRelationshipEvent((AssetLineageEventHeader)event);
        }
    }

    private void getContextForProcess(EntityDetail entityDetail, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ProcessContextHandler processContextHandler = instanceHandler.getProcessHandler(this.serverUserName, this.serverName, serviceOperationName);
        Map<String, Set<GraphContext>> processContext = processContextHandler.getProcessContext(this.serverUserName, entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setAssetContext(processContext);
        event.setAssetLineageEventType(AssetLineageEventType.PROCESS_CONTEXT_EVENT);
        this.publisher.publishRelationshipEvent((AssetLineageEventHeader)event);
    }

    private void getAssetContext(EntityDetail entityDetail, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String technicalGuid = entityDetail.getGUID();
        AssetContextHandler newAssetContextHandler = instanceHandler.getContextHandler(this.serverUserName, this.serverName, serviceOperationName);
        AssetContext assetContext = newAssetContextHandler.getAssetContext(this.serverName, this.serverUserName, technicalGuid, entityDetail.getType().getTypeDefName());
        GlossaryHandler glossaryHandler = instanceHandler.getGlossaryHandler(this.serverUserName, this.serverName, serviceOperationName);
        Map<String, Set<GraphContext>> context = glossaryHandler.getGlossaryTerm(technicalGuid, serviceOperationName, entityDetail, assetContext, this.validator);
        LineageEvent event = new LineageEvent();
        if (context.size() != 0) {
            event.setAssetContext(context);
        } else {
            event.setAssetContext(assetContext.getNeighbors());
        }
        event.setAssetLineageEventType(AssetLineageEventType.TECHNICAL_ELEMENT_CONTEXT_EVENT);
        this.publisher.publishRelationshipEvent((AssetLineageEventHeader)event);
    }

    private void processUpdatedEntity(EntityDetail entityDetail, String serviceOperationName) {
        log.debug("Asset Lineage OMAS start processing events for updating the following entity: {} ", (Object)entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.UPDATE_ENTITY_EVENT);
        this.publisher.publishRelationshipEvent((AssetLineageEventHeader)event);
    }
}

